/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.io.File;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.swt.WidgetContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderListPanel
implements WidgetContainer {
    private static final Message CLB_ADD_PATH = new Message(FolderListPanel.class, "clbAddPath");
    private static final Message CLB_REMOVE_PATH = new Message(FolderListPanel.class, "clbRemovePath");
    private String filterPath_;
    private String dialogTitle_;
    private String dialogMessage_;
    private Composite panel_ = null;
    private final UTable<File> utblFolder_;
    private Button btRemovePath_ = null;

    public FolderListPanel(File[] fileArray, UTableProvider<File> uTableProvider) {
        ArgumentChecker.throwIfNull((Object)fileArray, uTableProvider);
        this.utblFolder_ = new UTable<File>(uTableProvider, fileArray);
        this.filterPath_ = Ios.getCurrentDirectory().getAbsolutePath();
        this.dialogTitle_ = "";
        this.dialogMessage_ = "";
    }

    @Override
    public void close() {
    }

    public void setMessage(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        this.dialogTitle_ = string;
        this.dialogMessage_ = string2;
    }

    @Override
    public Control getControl() {
        return this.panel_;
    }

    public List<File> getFolders() {
        return this.utblFolder_.getRecords();
    }

    @Override
    public Control createContents(Composite composite) {
        this.panel_ = new Composite(composite, 0);
        this.panel_.setLayout(new GridLayout(2, false));
        this.createPathTable(this.panel_);
        Composite composite2 = new Composite(this.panel_, 0);
        composite2.setLayoutData(new GridData(16384, 16384, false, false));
        composite2.setLayout(new GridLayout(1, true));
        Button button = new Button(composite2, 8);
        button.setText(CLB_ADD_PATH.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderListPanel.this.addPath();
            }
        });
        this.btRemovePath_ = new Button(composite2, 8);
        this.btRemovePath_.setText(CLB_REMOVE_PATH.get());
        this.btRemovePath_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderListPanel.this.removePath();
            }
        });
        this.btRemovePath_.setEnabled(this.utblFolder_.getControl().getSelectionCount() != 0);
        return this.panel_;
    }

    private void createPathTable(Composite composite) {
        this.utblFolder_.createContents(composite);
        Table table = this.utblFolder_.getControl();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 200;
        table.setLayoutData(gridData);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FolderListPanel.this.updateWidgetStatus();
            }
        });
    }

    private void addPath() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.panel_.getShell());
        directoryDialog.setText(this.dialogTitle_);
        directoryDialog.setMessage(this.dialogMessage_);
        directoryDialog.setFilterPath(this.filterPath_);
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        this.filterPath_ = string;
        for (TableItem tableItem : this.utblFolder_.getControl().getItems()) {
            if (!string.equals(tableItem.getText())) continue;
            tableItem.setChecked(true);
            this.updateWidgetStatus();
            return;
        }
        File file = new File(string);
        this.utblFolder_.add(file);
        this.updateWidgetStatus();
    }

    private void removePath() {
        this.utblFolder_.removeSelected();
        this.updateWidgetStatus();
    }

    private void updateWidgetStatus() {
        this.btRemovePath_.setEnabled(this.utblFolder_.getControl().getSelectionCount() != 0);
    }
}

