/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;

public abstract class CanvasPanel
implements WidgetContainer {
    private Canvas canvas_ = null;
    private Image image_ = null;

    public Canvas createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.image_ = new Image((Device)this.canvas_.getDisplay(), this.getCanvasSize());
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CanvasPanel.this.paintOnCanvas(paintEvent);
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Swts.disposeQuietly(CanvasPanel.this.image_);
                CanvasPanel.this.image_ = null;
            }
        });
        return this.canvas_;
    }

    protected Rectangle getCanvasSize() {
        if (this.canvas_ == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        Rectangle rectangle = Geometry.createRectangle(new Point(0, 0), this.canvas_.getSize());
        if (rectangle.width == 0 || rectangle.height == 0) {
            return new Rectangle(0, 0, 100, 100);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintOnCanvas(PaintEvent paintEvent) {
        if (this.image_ != null) {
            paintEvent.gc.drawImage(this.image_, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            return;
        }
        GC gC = null;
        try {
            this.image_ = new Image((Device)this.canvas_.getDisplay(), this.getCanvasSize());
            gC = new GC(this.image_);
            this.paint(gC);
            paintEvent.gc.drawImage(this.image_, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
    }

    protected abstract void paint(GC var1);

    public Canvas getControl() {
        return this.canvas_;
    }

    protected void refresh() {
        if (this.canvas_ == null) {
            return;
        }
        Swts.disposeQuietly(this.image_);
        this.image_ = null;
        this.canvas_.redraw();
    }
}

