/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.sql.Column;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.Table;
import org.unitarou.sql.UBeanListHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checker {
    public static final Message NT_DB_ERROR = new Message(Checker.class, "ntDbError");
    private static final Message NT_TABLE_FOUND = new Message(Checker.class, "ntTableFound");
    private static final Message NT_TABLE_NOT_FOUND = new Message(Checker.class, "ntTableNotFound");
    private static final Message NT_COLUMN_NOT_FOUND = new Message(Checker.class, "ntColumnNotFound");
    private static final Message NT_COLUMN_MISMATCH_TYPE = new Message(Checker.class, "ntColumnMismatchType");
    private static final Message NT_COLUMN_MISMATCH_NULL = new Message(Checker.class, "ntColumnMismatchNull");
    private static final Message NT_COLUMN_MISMATCH_SIZE = new Message(Checker.class, "ntColumnMismatchSize");
    private static final Message NT_COLUMN_FOUND = new Message(Checker.class, "ntColumnFound");
    private static final Message NT_PK_MISMATCH_SIZE = new Message(Checker.class, "ntPkMismatchSize");
    private static final Message NT_PK_NOT_FOUND = new Message(Checker.class, "ntPkNotFound");
    private static final Message NT_PK_MISMATCH_ORDER = new Message(Checker.class, "ntPkMismatchOrder");
    private static final Message NT_PK_CHECKED = new Message(Checker.class, "ntPkChecked");
    private static final Message NT_FK_CHECKED = new Message(Checker.class, "ntFkChecked");
    private static final Message NT_FK_NOT_FOUND = new Message(Checker.class, "ntFkNotFound");
    private static final Message NT_DISUSED_FK_FOUND = new Message(Checker.class, "ntDisusedFkFound");
    private static final Checker instance_s_ = new Checker();

    public static Checker instance() {
        return instance_s_;
    }

    private Checker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckerResult hasTable(Connection connection, Table table) throws SQLException {
        ResultSet resultSet;
        String string;
        block3: {
            CheckerResult checkerResult;
            ArgumentChecker.throwIfNull((Object)connection, (Object)table);
            string = table.getTable();
            resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getTables(null, null, string, new String[]{"TABLE"});
                if (!resultSet.next()) break block3;
                checkerResult = new CheckerResult(NT_TABLE_FOUND.get((Object)string), CheckerResultType.MATCH);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                throw throwable;
            }
            DbUtils.closeQuietly(resultSet);
            return checkerResult;
        }
        CheckerResult checkerResult = new CheckerResult(NT_TABLE_NOT_FOUND.get((Object)string), CheckerResultType.NOT_FOUND);
        DbUtils.closeQuietly(resultSet);
        return checkerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckerResult> hasColumn(Connection connection, String string, Column[] columnArray) throws SQLException {
        Object object;
        ArgumentChecker.throwIfNull((Object)connection, (Object)string, (Object)columnArray);
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, null, string, "%");
            UBeanListHandler<Column> uBeanListHandler = new UBeanListHandler<Column>(Column.class);
            Object object2 = uBeanListHandler.handle(resultSet);
            HashMap<String, Column> hashMap = new HashMap<String, Column>();
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                Column object4 = (Column)object3.next();
                hashMap.put(object4.getColumnName(), object4);
            }
            object3 = new ArrayList(columnArray.length);
            for (Column column : columnArray) {
                Column column2 = (Column)hashMap.get(column.getColumnName());
                object3.add(this.hasColumnImpl(connection, string, column, column2));
            }
            object = object3;
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(resultSet);
            throw throwable;
        }
        DbUtils.closeQuietly(resultSet);
        return object;
    }

    private CheckerResult hasColumnImpl(Connection connection, String string, Column column, Column column2) {
        ArgumentChecker.throwIfNull((Object)connection, (Object)string, (Object)column);
        if (column2 == null) {
            return new CheckerResult(NT_COLUMN_NOT_FOUND.get(string, column.getColumnName()), CheckerResultType.UNMATCH);
        }
        if (!column2.getTypeName().equals(column.getTypeName())) {
            return new CheckerResult(NT_COLUMN_MISMATCH_TYPE.get(string, column.getColumnName(), column.getTypeName(), column2.getTypeName()), CheckerResultType.UNMATCH);
        }
        if (column2.getNullable() != column.getNullable()) {
            return new CheckerResult(NT_COLUMN_MISMATCH_NULL.get(string, column.getColumnName(), column.getNullableString(), column2.getNullableString()), CheckerResultType.UNMATCH);
        }
        if (column2.getTypeName().contains("CHAR") || column2.getTypeName().contains("BINARY")) {
            int n = column2.getColumnSize();
            int n2 = n = n == Integer.MAX_VALUE ? 0 : n;
            if (n != column.getColumnSize()) {
                return new CheckerResult(NT_COLUMN_MISMATCH_SIZE.get(string, column.getColumnName(), column.getColumnSize(), column2.getColumnSize()), CheckerResultType.UNMATCH);
            }
        }
        return new CheckerResult(NT_COLUMN_FOUND.get(string, column.getColumnName()), CheckerResultType.MATCH);
    }

    /*
     * Exception decompiling
     */
    public CheckerResult hasPrimeryKey(Connection var1_1, String var2_2, PrimaryKey[] var3_3) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckerResult hasForeignKey(Connection connection, String string, ForeignKey[] foreignKeyArray) throws SQLException {
        Object object;
        Object object2;
        ResultSet resultSet;
        block7: {
            ArrayList<ForeignKey> arrayList;
            block6: {
                ArgumentChecker.throwIfNull((Object)connection, (Object)string, (Object)foreignKeyArray);
                resultSet = null;
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    resultSet = databaseMetaData.getImportedKeys(null, null, string);
                    UBeanListHandler<ForeignKey> uBeanListHandler = new UBeanListHandler<ForeignKey>(ForeignKey.class);
                    object2 = uBeanListHandler.handle(resultSet);
                    arrayList = new ArrayList<ForeignKey>(Arrays.asList(foreignKeyArray));
                    object = object2.iterator();
                    while (object.hasNext()) {
                        ForeignKey foreignKey = (ForeignKey)object.next();
                        for (ForeignKey foreignKey2 : foreignKeyArray) {
                            if (!foreignKey2.equals(foreignKey)) continue;
                            object.remove();
                            arrayList.remove(foreignKey2);
                        }
                    }
                    if (!object2.isEmpty() || !arrayList.isEmpty()) break block6;
                    object = new CheckerResult(NT_FK_CHECKED.get((Object)string), CheckerResultType.MATCH);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(resultSet);
                    throw throwable;
                }
                DbUtils.closeQuietly(resultSet);
                return object;
            }
            if (arrayList.isEmpty()) break block7;
            object = new CheckerResult(NT_FK_NOT_FOUND.get(string, arrayList), CheckerResultType.NOT_FOUND);
            DbUtils.closeQuietly(resultSet);
            return object;
        }
        object = new CheckerResult(NT_DISUSED_FK_FOUND.get(string, object2), CheckerResultType.MATCH);
        DbUtils.closeQuietly(resultSet);
        return object;
    }
}

