/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;

public class NumericStyleProvider
implements CoordinatesLabelProvider {
    private static final Message LB_DISPLAY_NAME = new Message(NumericStyleProvider.class, "lbDisplayName");

    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return String.valueOf(sgfPoint.x());
    }

    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return String.valueOf(sgfPoint.y());
    }

    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return '(' + this.getXLabel(sgfPoint) + ',' + this.getYLabel(sgfPoint) + ')';
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

