/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.pc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.pc.DefaultRightProblemConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UliGo
extends DefaultRightProblemConverter {
    @Override
    public boolean isSatisfied(GameTree gameTree) {
        Node node = gameTree.getSequence().getFirst();
        if (node != null && this.isWrongNode(node)) {
            return true;
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            if (!this.isSatisfied(gameTree2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isWrongNode(Node node) {
        List<SgfPoint> list = this.findWrongPos(node);
        if (list.isEmpty()) {
            return false;
        }
        Stone stone = Stone.create(node, SgfSize.MAX);
        for (SgfPoint sgfPoint : list) {
            if (!sgfPoint.equals(stone.getPoint())) continue;
            return true;
        }
        return false;
    }

    private List<SgfPoint> findWrongPos(Node node) {
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>();
        for (SgfId sgfId : new SgfId[]{SgfId.TRIANGLE, SgfId.WRONG_VARIATION}) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            for (SgfPoint sgfPoint : SgfPoint.parse(SgfSize.MAX, property.getStrings())) {
                arrayList.add(sgfPoint);
            }
        }
        return arrayList;
    }

    @Override
    public void appendConfig(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return;
        }
        Property property = new Property(sgfColor.situationType(), SgfDouble.EMPHASIZED.getString());
        this.setIfAllWrong(rootGameTree, property);
    }

    private boolean setIfAllWrong(GameTree gameTree, Property property) {
        for (Node node : gameTree.getSequence()) {
            if (!property.equals(node.getProperty(property.sgfId()))) continue;
            return false;
        }
        int n = 0;
        boolean bl = true;
        boolean[] blArray = new boolean[gameTree.getChildrenSize()];
        for (GameTree object : gameTree.getChildren()) {
            blArray[n] = this.setIfAllWrong(object, property);
            bl &= blArray[n];
            ++n;
        }
        if (bl) {
            return true;
        }
        for (int i = 0; i < blArray.length; ++i) {
            Node node;
            Stone stone;
            Sequence sequence;
            if (!blArray[i] || (sequence = gameTree.getChild(i).getSequence()).isEmpty() || !(stone = Stone.create(node = sequence.getFirst(), SgfSize.MAX)).isValid()) continue;
            node.addProperty(new Property(SgfId.WRONG_VARIATION, stone.getPoint().getString()));
        }
        return false;
    }

    @Override
    public void removeConfig(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.removeConfigImpl(rootGameTree);
    }

    private void removeConfigImpl(GameTree gameTree) {
        Node node = gameTree.getSequence().getFirst();
        if (node != null && this.isWrongNode(node)) {
            Stone object = Stone.create(node, SgfSize.MAX);
            SgfId[] sgfIdArray = new SgfId[]{SgfId.WRONG_VARIATION, SgfId.TRIANGLE};
            int n = sgfIdArray.length;
            for (int gameTree2 = 0; gameTree2 < n; ++gameTree2) {
                SgfId sgfId = sgfIdArray[gameTree2];
                if (!this.removeConfigImpl(node, object, sgfId)) continue;
                return;
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.removeConfigImpl(gameTree2);
        }
    }

    private boolean removeConfigImpl(Node node, Stone stone, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        if (property == null) {
            return false;
        }
        String[] stringArray = property.getStrings();
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>(Arrays.asList(SgfPoint.parse(SgfSize.MAX, stringArray)));
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((SgfPoint)arrayList.get(i)).equals(stone.getPoint())) continue;
            arrayList.remove(i);
            break;
        }
        if (arrayList.isEmpty()) {
            node.removeProperty(sgfId);
        } else {
            property.clearValue();
            for (SgfPoint sgfPoint : arrayList) {
                property.addValue(new Value(sgfPoint.getString()));
            }
            node.addProperty(property);
        }
        return true;
    }
}

