/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveSgfIdFilter
extends NestedFilter<RootGameTree> {
    private final SgfId[] targetSgfIds_;

    public RemoveSgfIdFilter(SgfId ... sgfIdArray) {
        this((Filter<RootGameTree>)null, sgfIdArray);
    }

    public RemoveSgfIdFilter(Filter<RootGameTree> filter, SgfId ... sgfIdArray) {
        super(filter);
        this.targetSgfIds_ = new SgfId[sgfIdArray.length];
        System.arraycopy(sgfIdArray, 0, this.targetSgfIds_, 0, this.targetSgfIds_.length);
    }

    @Override
    public RootGameTree filter(RootGameTree rootGameTree) throws FilterException {
        RootGameTree rootGameTree2 = super.filter(rootGameTree);
        this.filterImpl(rootGameTree2);
        return rootGameTree2;
    }

    private void filterImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            for (SgfId sgfId : this.targetSgfIds_) {
                node.removeProperty(sgfId);
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.filterImpl(gameTree2);
        }
    }
}

