/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorXFilter
extends NestedFilter<SgfPoint> {
    public MirrorXFilter() {
        this((NestedFilter<SgfPoint>)null);
    }

    public MirrorXFilter(NestedFilter<SgfPoint> nestedFilter) {
        super(nestedFilter);
    }

    @Override
    public SgfPoint filter(SgfPoint sgfPoint) throws FilterException {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        sgfPoint = super.filter(sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return sgfPoint;
        }
        int n = sgfPoint.size().width() - sgfPoint.x() + 1;
        int n2 = sgfPoint.y();
        SgfSize sgfSize = sgfPoint.size();
        if (n <= sgfSize.width() && n2 <= sgfSize.height()) {
            return SgfPoint.create(sgfPoint.size(), n, n2);
        }
        throw new FilterException();
    }
}

