/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfReal
implements TypedString<SgfReal> {
    private static final Log log_s_ = LogFactory.getLog(SgfReal.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+(|\\.\\d+)");
    private final double real_;

    public static SgfReal parse(String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        try {
            return new SgfReal(Double.parseDouble(matcher.group()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeParseException("Bad argument value = " + string);
        }
    }

    public static SgfReal parseQuietly(String string) {
        try {
            return SgfReal.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.log(LogLevel.DEBUG, typeParseException, "Bad value for parse: {0}", string);
            return null;
        }
    }

    public SgfReal(double d) {
        this.real_ = d;
    }

    public double getReal() {
        return this.real_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.REAL.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        return Double.toString(this.real_);
    }

    @Override
    public int compareTo(SgfReal sgfReal) {
        return Double.compare(this.real_, sgfReal.real_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SgfReal)) {
            return false;
        }
        SgfReal sgfReal = (SgfReal)object;
        return Double.doubleToLongBits(this.real_) == Double.doubleToLongBits(sgfReal.real_);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.real_);
        return (int)(l ^ l >>> 32);
    }
}

