/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfNumber
implements TypedString<SgfNumber> {
    private static final Log log_s_ = LogFactory.getLog(SgfNumber.class);
    private static final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+");
    private final Integer number_;

    public static SgfNumber parse(String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        return new SgfNumber(Integer.parseInt(matcher.group()));
    }

    public static SgfNumber parseQuietly(String string) {
        try {
            return SgfNumber.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.log(LogLevel.DEBUG, typeParseException, "Bad value for parse: {0}", string);
            return null;
        }
    }

    public static boolean isValid(String string) {
        return condition_s_.matcher(string).matches();
    }

    public SgfNumber(int n) {
        this.number_ = n;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.NUMBER.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        return this.number_ == null ? "" : this.number_.toString();
    }

    public int getIntValue() {
        return this.number_;
    }

    @Override
    public int compareTo(SgfNumber sgfNumber) {
        return this.number_.compareTo(sgfNumber.number_);
    }

    public String toString() {
        return this.number_.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        SgfNumber sgfNumber = (SgfNumber)object;
        if (sgfNumber.number_ == null) {
            return this.number_ == null;
        }
        return sgfNumber.number_.equals(this.number_);
    }

    public int hashCode() {
        return this.number_ == null ? Integer.MIN_VALUE : this.number_.hashCode();
    }
}

