/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.nio.charset.Charset;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfCharset
implements TypedString<SgfCharset> {
    private static final Log log_s_ = LogFactory.getLog(SgfCharset.class);
    private final Charset charset_;

    public static SgfCharset parse(String string) {
        return new SgfCharset(string);
    }

    public SgfCharset(Charset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        this.charset_ = charset;
    }

    private SgfCharset(String string) {
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            charset = Charset.defaultCharset();
            log_s_.log(LogLevel.WARN, illegalArgumentException, "{0} is not a valid charset name. Use default chaset: {1}", string, charset);
        }
        this.charset_ = charset;
    }

    public Charset getCharset() {
        return this.charset_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.CHARSET);
    }

    @Override
    public String getString() {
        return this.charset_.name();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        SgfCharset sgfCharset = (SgfCharset)object;
        return sgfCharset.charset_.equals(this.charset_);
    }

    public int hashCode() {
        return this.charset_.hashCode();
    }

    @Override
    public int compareTo(SgfCharset sgfCharset) {
        return this.charset_.compareTo(sgfCharset.charset_);
    }
}

