/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.cmd.RemoveLastNode;

public class RemoveNode
extends AbstractCommand {
    private final GameTree parent_;
    private final GameTree gameTree_;
    private final Node target_;
    private final Node insertPoint_;
    private final GameTree[] children_;
    private final GameTree[] siblings_;
    private final RemoveLastNode removeLastNode_;

    public RemoveNode(GameTree gameTree, Node node) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)node);
        this.gameTree_ = gameTree;
        this.parent_ = this.gameTree_.getParent();
        Sequence sequence = this.gameTree_.getSequence();
        if (this.gameTree_ instanceof RootGameTree && sequence.size() == 1 && 2 <= this.gameTree_.getChildrenSize()) {
            throw new IllegalArgumentException("Bad argument, can't remove root sequence.");
        }
        this.target_ = node;
        boolean bl = false;
        Node node2 = null;
        Sequence.Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            Node node3 = (Node)iterator.next();
            if (node3 != this.target_) continue;
            node2 = iterator.hasNext() ? (Node)iterator.next() : null;
            bl = true;
            break;
        }
        this.insertPoint_ = node2;
        if (!bl) {
            throw new IllegalArgumentException("Can't find target node(" + this.target_ + ") in the sequence (" + sequence + ')');
        }
        if (sequence.size() == 1) {
            this.children_ = gameTree.getChildren();
            this.siblings_ = this.parent_.getChildren();
        } else {
            this.children_ = null;
            this.siblings_ = null;
        }
        this.removeLastNode_ = this.gameTree_.getSequence().getLast() == this.target_ && this.gameTree_.getChildrenSize() == 0 ? new RemoveLastNode(this.gameTree_) : null;
    }

    public void execute() {
        super.execute();
        if (this.removeLastNode_ != null) {
            this.removeLastNode_.execute();
            return;
        }
        Sequence sequence = this.gameTree_.getSequence();
        sequence.remove(this.target_);
        if (sequence.size() != 0) {
            return;
        }
        this.parent_.removeGameTree(this.gameTree_);
        for (GameTree gameTree : this.children_) {
            this.gameTree_.removeGameTree(gameTree);
            this.parent_.addGameTree(gameTree);
        }
    }

    public void undo() {
        super.undo();
        if (this.removeLastNode_ != null) {
            this.removeLastNode_.undo();
            return;
        }
        Sequence sequence = this.gameTree_.getSequence();
        if (this.insertPoint_ != null) {
            sequence.insert(this.target_, this.insertPoint_);
        } else {
            sequence.addLast(this.target_);
        }
        if (sequence.size() != 1) {
            return;
        }
        for (GameTree gameTree : this.siblings_) {
            this.parent_.removeGameTree(gameTree);
        }
        for (GameTree gameTree : this.children_) {
            this.parent_.removeGameTree(gameTree);
        }
        for (GameTree gameTree : this.siblings_) {
            this.parent_.addGameTree(gameTree);
        }
        for (GameTree gameTree : this.children_) {
            this.gameTree_.addGameTree(gameTree);
        }
    }
}

