/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.nio.charset.Charset;
import java.text.StringCharacterIterator;
import org.unitarou.lang.ArgumentChecker;

public class Strings {
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Charset CHARSET_US_ASCII = Charset.forName("US-ASCII");
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final char[][] FULLWIDTH_TABLE = new char[][]{{'\uff10', '0'}, {'\uff11', '1'}, {'\uff12', '2'}, {'\uff13', '3'}, {'\uff14', '4'}, {'\uff15', '5'}, {'\uff16', '6'}, {'\uff17', '7'}, {'\uff18', '8'}, {'\uff19', '9'}, {'\u3007', '0'}, {'\u4e00', '1'}, {'\u4e8c', '2'}, {'\u4e09', '3'}, {'\u56db', '4'}, {'\u4e94', '5'}, {'\u516d', '6'}, {'\u4e03', '7'}, {'\u516b', '8'}, {'\u4e5d', '9'}, {'\u96f6', '0'}, {'\u58f1', '1'}, {'\u5f10', '2'}, {'\u53c2', '3'}, {'\u2460', '1'}, {'\u2461', '2'}, {'\u2462', '3'}, {'\u2463', '4'}, {'\u2464', '5'}, {'\u2465', '6'}, {'\u2466', '7'}, {'\u2467', '8'}, {'\u2468', '9'}, {'\u2160', '1'}, {'\u2161', '2'}, {'\u2162', '3'}, {'\u2163', '4'}, {'\u2164', '5'}, {'\u2165', '6'}, {'\u2166', '7'}, {'\u2167', '8'}, {'\u2168', '9'}, {'\u2170', '1'}, {'\u2171', '2'}, {'\u2172', '3'}, {'\u2173', '4'}, {'\u2174', '5'}, {'\u2175', '6'}, {'\u2176', '7'}, {'\u2177', '8'}, {'\u2178', '9'}, {'\uff0e', '.'}, {'\u3002', '.'}, {'\uff61', '.'}};

    public static boolean equalsIgnoreEolType(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringCharacterIterator stringCharacterIterator2 = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        char c2 = stringCharacterIterator2.first();
        while (true) {
            if (c == '\r' && (c = stringCharacterIterator.next()) != '\n') {
                c = stringCharacterIterator.previous();
            }
            if (c2 == '\r' && (c2 = stringCharacterIterator2.next()) != '\n') {
                c2 = stringCharacterIterator2.previous();
            }
            if (!(c != '\r' && c != '\n' || c2 != '\r' && c2 != '\n')) {
                c = stringCharacterIterator.next();
                c2 = stringCharacterIterator2.next();
                continue;
            }
            if (c != c2) break;
            if (c == '\uffff') {
                return true;
            }
            c = stringCharacterIterator.next();
            c2 = stringCharacterIterator2.next();
        }
        return false;
    }

    public static boolean isUppercaseRomanAlphabet(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static CharSequence composeDuration(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2).append(':');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder;
    }

    public static int calcDiffSize(CharSequence charSequence, CharSequence charSequence2) {
        ArgumentChecker.throwIfNull((Object)charSequence, (Object)charSequence2);
        return Math.max(charSequence.length(), charSequence2.length()) - Strings.calcLscLength(charSequence, charSequence2);
    }

    public static int calcLscLength(CharSequence charSequence, CharSequence charSequence2) {
        ArgumentChecker.throwIfNull((Object)charSequence, (Object)charSequence2);
        if (charSequence.length() == 0 || charSequence2.length() == 0) {
            return 0;
        }
        int[][] nArray = new int[charSequence.length() + 1][charSequence2.length() + 1];
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            for (int j = 1; j < nArray[i].length; ++j) {
                nArray[i][j] = charSequence.charAt(i - 1) == charSequence2.charAt(j - 1) ? nArray[i - 1][j - 1] + 1 : Math.max(nArray[i - 1][j], nArray[i][j - 1]);
                n = Math.max(n, nArray[i][j]);
            }
        }
        return n;
    }

    public static CharSequence concatWithComma(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object.toString()).append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder;
    }

    public static CharSequence nullToNullMark(CharSequence charSequence) {
        return charSequence != null ? charSequence : "<<null>>";
    }

    public static String nullToEmpty(String string) {
        return string != null ? string : EMPTY;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static CharSequence escapeLineSaparator(CharSequence charSequence) {
        ArgumentChecker.throwIfNull((Object)charSequence);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        block4: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block4;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder;
    }

    public static String replaceFullwidthDigit(String string) {
        for (char[] cArray : FULLWIDTH_TABLE) {
            string = string.replace(cArray[0], cArray[1]);
        }
        return string;
    }

    protected Strings() {
    }
}

