/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;

public final class RgbCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(RgbCodec.class);

    public boolean isEncodable(Object object) {
        return object instanceof RGB;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        RGB rGB = (RGB)object;
        return StringConverter.asString(rGB);
    }

    public Object decode(String string) {
        try {
            return StringConverter.asRGB(string);
        }
        catch (DataFormatException dataFormatException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] Invalid value: {0}", string);
            return null;
        }
    }
}

