/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.unitarou.jface.pref.PreferenceArrayCodec;
import org.unitarou.lang.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileArrayCodec
implements PreferenceArrayCodec<File> {
    @Override
    public boolean isEncodable(Object object) {
        if (object instanceof File[]) {
            return true;
        }
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (e instanceof File) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (object instanceof File[]) {
            return this.encode((Collection<File>)Arrays.asList((File[])object));
        }
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        for (Object e : (Collection)object) {
            if (e instanceof File) continue;
            throw new IllegalArgumentException(e.getClass().getName());
        }
        return this.encode((Collection)object);
    }

    @Override
    public String encode(Collection<File> collection) {
        ArgumentChecker.throwIfNull(collection);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : collection) {
            stringBuilder.append(file.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public File[] decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new File(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

