/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumSetCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(EnumSetCodec.class);
    private static final String DELIMITER = ",";

    @Override
    public boolean isEncodable(Object object) {
        return object instanceof EnumSet;
    }

    @Override
    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((EnumSet)object);
    }

    public <E extends Enum<E>> String encode(EnumSet<E> enumSet) {
        EnumSet<E> enumSet2;
        ArgumentChecker.throwIfNull(enumSet);
        EnumSet<E> enumSet3 = enumSet2 = enumSet.isEmpty() ? EnumSet.complementOf(enumSet) : enumSet;
        if (enumSet2.isEmpty()) {
            return "";
        }
        Enum enum_ = (Enum)enumSet2.iterator().next();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(enum_.getDeclaringClass().getName()).append('@');
        for (Enum enum_2 : enumSet) {
            stringBuilder.append(enum_2.name()).append(DELIMITER);
        }
        if (!enumSet.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.log(LogLevel.WARN, "[IGNORE] Unknown type value: {0}", string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            if (enumArray == null) {
                log_s_.log(LogLevel.WARN, "[IGNORE] Unknown type value: {0}", string);
                return null;
            }
            ArrayList<Enum> arrayList = new ArrayList<Enum>();
            for (Enum enum_ : enumArray) {
                if (!hashSet.contains(enum_.name())) continue;
                arrayList.add(enum_);
            }
            return EnumSet.copyOf(arrayList);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] {0}@{1}", string, classNotFoundException.getLocalizedMessage());
            return null;
        }
    }
}

