/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.provider.rgtlp.DefaultRgtLabelProvider;

public class GreedyRgtLabelProvider
extends DefaultRgtLabelProvider {
    public String displayName() {
        return super.displayName();
    }

    public String getLabel(RootGameTree rootGameTree) {
        String label = super.getLabel(rootGameTree);
        if (label.length() != 0) {
            return label;
        }
        switch (rootGameTree.getGameType()) {
            case GAME: {
                return this.getLabelAsGame(rootGameTree);
            }
            case PROBLEM: {
                return this.getLabelAsProblem(rootGameTree);
            }
            case DRILL: {
                return this.getLabelAsDrill(rootGameTree);
            }
        }
        return label;
    }

    private String getLabelAsGame(RootGameTree rootGameTree) {
        StringBuilder builder = new StringBuilder();
        builder.append(GameType.GAME.displayName()).append('[').append(rootGameTree.getSize().toString()).append(',');
        String haString = this.makeHandicapLabel(rootGameTree);
        if (haString.length() != 0) {
            builder.append(haString).append(',');
        }
        builder.append(this.countMoves(rootGameTree)).append("\u624b").append(']');
        return builder.toString();
    }

    private String makeHandicapLabel(RootGameTree rootGameTree) {
        String datum = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.HANDICAP);
        if (datum.length() == 0) {
            return "";
        }
        SgfNumber number = SgfNumber.parseQuietly(datum);
        if (number == null) {
            return "";
        }
        Handicap handicap = new Handicap(number.getIntValue());
        return handicap.displayName();
    }

    private int countMoves(RootGameTree rootGameTree) {
        int ret = 0;
        RootGameTree gameTree = rootGameTree;
        while (gameTree != null) {
            Sequence sequence = gameTree.getSequence();
            for (Node node : sequence) {
                if (!node.contains(SgfId.BLACK) && !node.contains(SgfId.WHITE)) continue;
                ++ret;
            }
            GameTree gameTree2 = gameTree = gameTree.getChildrenSize() == 0 ? null : gameTree.getChild(0);
        }
        return ret;
    }

    private String getLabelAsProblem(RootGameTree rootGameTree) {
        StringBuilder builder = new StringBuilder();
        builder.append(GameType.PROBLEM.displayName()).append('[');
        String result = this.makeResultLabel(rootGameTree);
        if (result.length() != 0) {
            builder.append(result).append(',');
        }
        builder.append(this.countMoves(rootGameTree)).append("\u624b").append(']');
        return builder.toString();
    }

    private String makeResultLabel(RootGameTree rootGameTree) {
        String datum = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.RESULT);
        if (datum.length() == 0) {
            return "";
        }
        Result result = Result.parse(datum);
        switch (result.getArchetype()) {
            case OTHER: {
                return result.getValue();
            }
            case WHITE_WIN: 
            case BLACK_WIN: {
                return String.valueOf(result.getArchetype().displayName()) + result.getScore();
            }
        }
        return result.getArchetype().displayName();
    }

    private String getLabelAsDrill(RootGameTree rootGameTree) {
        StringBuilder builder = new StringBuilder();
        builder.append(GameType.DRILL.displayName()).append('[').append(this.countProblems(rootGameTree)).append("\u554f").append(']');
        return builder.toString();
    }

    private int countProblems(RootGameTree rootGameTree) {
        String[] data = BasicFinder.findData(rootGameTree.getSequence(), SgfId.INPUT_FILES);
        if (data == null) {
            return 0;
        }
        return data.length;
    }
}

