/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;
import org.unitarou.yukinoshita.view.jface.ns.NodeListContentProvider;
import org.unitarou.yukinoshita.view.jface.ns.NodeListLabelProvider;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListPanel
implements Adaptable,
WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(NodeListPanel.class);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeList nodeList_ = null;
    private TableViewer tableViewer_ = null;
    private final Adapter adapter_ = new Adapter();
    private boolean inRefresh_ = false;
    static /* synthetic */ Class class$0;

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        this.tableViewer_ = new TableViewer(parent, 68356);
        this.tableViewer_.setContentProvider(new NodeListContentProvider());
        this.tableViewer_.setLabelProvider(new NodeListLabelProvider());
        Table table = this.tableViewer_.getTable();
        table.setHeaderVisible(false);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 131072);
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        this.tableViewer_.setInput(null);
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NodeListPanel.this.fireNodeSelected();
            }
        });
        MouseOnGroupListener listener = new MouseOnGroupListener();
        table.addListener(37, listener);
        table.addMouseTrackListener(listener);
        return table;
    }

    @Override
    public void dispose() {
    }

    private void packColumns() {
        TableColumn[] columns = this.tableViewer_.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    private void fireNodeSelected() {
        if (this.inRefresh_) {
            return;
        }
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        NodeSelectionCommand command = new NodeSelectionCommand(index);
        this.eventBroker_.executeCommand(command);
    }

    public void refresh() {
        this.inRefresh_ = true;
        this.tableViewer_.getTable().setRedraw(false);
        try {
            int index = this.tableViewer_.getTable().getSelectionIndex();
            int i = 0;
            while (i < this.nodeList_.size()) {
                this.tableViewer_.update(this.nodeList_.getNodeView(i), null);
                ++i;
            }
            this.packColumns();
            this.tableViewer_.getTable().setSelection(index);
        }
        finally {
            this.tableViewer_.getTable().setRedraw(true);
            this.inRefresh_ = false;
        }
    }

    private class MouseOnGroupListener
    extends MouseTrackAdapter
    implements Listener {
        MouseOnGroupListener() {
        }

        public void handleEvent(Event event) {
            Table table = NodeListPanel.this.tableViewer_.getTable();
            table.getVerticalBar().setThumb(1);
            int index = table.getSelectionIndex();
            if (index < 0) {
                return;
            }
            if (event.count > 0) {
                if ((index -= event.count / 3) < 0) {
                    index = 0;
                }
            } else if (event.count < 0 && table.getItemCount() <= (index -= event.count / 3)) {
                index = table.getItemCount() - 1;
            }
            if (table.getSelectionIndex() != index) {
                table.setSelection(index);
                NodeListPanel.this.fireNodeSelected();
            }
        }

        public void mouseEnter(MouseEvent e) {
            if (NodeListPanel.this.tableViewer_.getTable().getShell() == Display.getCurrent().getActiveShell()) {
                NodeListPanel.this.tableViewer_.getTable().forceFocus();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameMonitor,
    NodeListMonitor,
    NodeMonitor,
    ModelEventNotifier,
    ContextMonitor {
        private CurrentContext context_ = CurrentContext.nullContext;
        static /* synthetic */ Class class$0;

        Adapter() {
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.context_ = gameMediator.getContext();
            NodeList newList = gameMediator.getNodeList();
            if (newList != NodeListPanel.this.nodeList_) {
                NodeListPanel.this.nodeList_ = newList;
            } else {
                int i = 0;
                while (i < NodeListPanel.this.nodeList_.size()) {
                    NodeListPanel.this.tableViewer_.update(NodeListPanel.this.nodeList_.getNodeView(i), null);
                    ++i;
                }
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("update(GameMediator gameMediator)" + gameMediator.toString());
            }
        }

        @Override
        public void update(NodeView[] nodeViews) {
            ArgumentChecker.throwIfNull((Object)nodeViews);
            NodeView[] nodeViewArray = nodeViews;
            int n = 0;
            int n2 = nodeViewArray.length;
            while (n < n2) {
                NodeView nodeView = nodeViewArray[n];
                this.currentChanged(nodeView);
                ++n;
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("update(NodeView[] nodeViews)" + nodeViews.toString());
            }
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (NodeListPanel.this.nodeList_ == null) {
                throw new IllegalStateException("Method must be called after #update(GameMediator) called,");
            }
            boolean needsColumnPack = false;
            int lastSelectionIndex = NodeListPanel.this.tableViewer_.getTable().getSelectionIndex();
            int viewSize = NodeListPanel.this.tableViewer_.getTable().getItemCount();
            int evalEndPos = Math.min(NodeListPanel.this.nodeList_.size(), viewSize);
            int i = 0;
            while (i < evalEndPos) {
                if (!NodeListPanel.this.nodeList_.getNodeView(i).equals(NodeListPanel.this.tableViewer_.getElementAt(i))) {
                    if (log_s_.isTraceEnabled()) {
                        log_s_.trace("Replace [" + i + ',' + evalEndPos + ')');
                    }
                    int j = i;
                    while (j < evalEndPos) {
                        NodeListPanel.this.tableViewer_.replace(NodeListPanel.this.nodeList_.getNodeView(j), j);
                        ++j;
                    }
                    if (log_s_.isTraceEnabled()) {
                        log_s_.trace("Remove A [" + evalEndPos + ',' + viewSize + ')');
                    }
                    NodeListPanel.this.tableViewer_.remove(this.partOfViewItem(evalEndPos, viewSize));
                    viewSize = NodeListPanel.this.tableViewer_.getTable().getItemCount();
                    needsColumnPack = true;
                    break;
                }
                ++i;
            }
            if (viewSize < NodeListPanel.this.nodeList_.size()) {
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Add [" + viewSize + ',' + NodeListPanel.this.nodeList_.size() + ')');
                }
                NodeListPanel.this.tableViewer_.add(this.partOfModelItem(viewSize, NodeListPanel.this.nodeList_.size()));
                needsColumnPack = true;
            } else if (NodeListPanel.this.nodeList_.size() < viewSize) {
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Remove B [" + NodeListPanel.this.nodeList_.size() + ',' + viewSize + ')');
                }
                NodeListPanel.this.tableViewer_.remove(this.partOfViewItem(NodeListPanel.this.nodeList_.size(), viewSize));
                needsColumnPack = true;
            }
            if (needsColumnPack) {
                NodeListPanel.this.packColumns();
            }
            viewSize = NodeListPanel.this.tableViewer_.getTable().getItemCount();
            int index = -1;
            int i2 = 0;
            while (i2 < viewSize) {
                if (nodeView.isSameNodeEntity((NodeView)NodeListPanel.this.tableViewer_.getElementAt(i2))) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index == -1) {
                index = Math.min(lastSelectionIndex, NodeListPanel.this.nodeList_.size() - 1);
            }
            NodeListPanel.this.tableViewer_.update(nodeView, null);
            NodeListPanel.this.tableViewer_.getTable().setSelection(index);
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("currentChanged(NodeView nodeView): Update [" + index + ']' + nodeView);
            }
        }

        private Object[] partOfViewItem(int start, int end) {
            Object[] items = new Object[end - start];
            int index = 0;
            int i = start;
            while (i < end) {
                items[index] = NodeListPanel.this.tableViewer_.getElementAt(i);
                ++index;
                ++i;
            }
            return items;
        }

        private Object[] partOfModelItem(int start, int end) {
            Object[] items = new Object[end - start];
            int index = 0;
            int i = start;
            while (i < end) {
                items[index] = NodeListPanel.this.nodeList_.getNodeView(i);
                ++index;
                ++i;
            }
            return items;
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            NodeListPanel.this.eventBroker_.removeView(NodeListPanel.this);
            NodeListPanel.this.eventBroker_ = eventBroker;
            NodeListPanel.this.eventBroker_.addView(NodeListPanel.this);
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("setEventBroker(EventBroker eventBroker)" + NodeListPanel.this.eventBroker_);
            }
        }

        @Override
        public void attributeChanged(Set<String> keySet) {
            ArgumentChecker.throwIfNull(keySet);
            boolean needsRefresh = false;
            if (keySet.contains(CoordinatesLabelProvider.class.getName())) {
                NodeListLabelProvider provider = (NodeListLabelProvider)NodeListPanel.this.tableViewer_.getLabelProvider();
                CoordinatesLabelProvider newProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
                CoordinatesLabelProvider lastProvider = provider.getProvider();
                if (!lastProvider.equals(newProvider)) {
                    provider.setProvider(newProvider);
                    needsRefresh = true;
                }
            }
            if (needsRefresh) {
                NodeListPanel.this.refresh();
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("attributeChanged(Set<String> keySet)" + keySet);
            }
        }
    }
}

