/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.CommandFactory;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteMemoPanel
implements Adaptable,
WidgetContainer {
    private static final MessageResource LB_NOTE = new MessageResource(NoteMemoPanel.class, "lbNote");
    private final boolean showNote_;
    private Composite frame_ = null;
    private NodeView nodeView_ = null;
    private Text nodeName_;
    private Text comment_;
    private EventBroker eventBroker_;
    private final Adapter adapter_;
    private boolean isModelUpdateMode_;
    static /* synthetic */ Class class$0;

    public NoteMemoPanel() {
        this(true);
    }

    public NoteMemoPanel(boolean showNote) {
        this.showNote_ = showNote;
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.adapter_ = new Adapter();
        this.isModelUpdateMode_ = false;
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        this.frame_ = new Composite(parent, 0);
        this.frame_.setLayout(new FormLayout());
        this.createNote(this.frame_);
        this.createComment(this.frame_);
        return this.frame_;
    }

    private void createNote(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LB_NOTE.get());
        label.setVisible(this.showNote_);
        this.nodeName_ = new Text(parent, 2048);
        this.nodeName_.setEditable(false);
        this.nodeName_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NoteMemoPanel.this.update(NoteMemoPanel.this.nodeName_.getText(), SgfId.NODENAME);
            }
        });
        this.nodeName_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoteMemoPanel.this.checkAndUpdate(NoteMemoPanel.this.nodeName_.getText(), SgfId.NODENAME);
            }
        });
        this.nodeName_.setVisible(this.showNote_);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 2);
        fdLabel.top = new FormAttachment(0, 2);
        label.setLayoutData(fdLabel);
        FormData fdNodename = new FormData();
        fdNodename.left = new FormAttachment(label, 2);
        fdNodename.top = new FormAttachment(0, 2);
        fdNodename.right = new FormAttachment(100, 2);
        this.nodeName_.setLayoutData(fdNodename);
    }

    private void createComment(Composite parent) {
        this.comment_ = new Text(parent, 2626);
        FormData fdComment = new FormData();
        fdComment.left = new FormAttachment(0, 0);
        fdComment.top = new FormAttachment(this.nodeName_, 2);
        fdComment.right = new FormAttachment(100, 2);
        fdComment.bottom = new FormAttachment(100, 2);
        this.comment_.setLayoutData(fdComment);
        this.comment_.setEditable(false);
        this.comment_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NoteMemoPanel.this.update(NoteMemoPanel.this.comment_.getText(), SgfId.COMMENT);
            }
        });
        this.comment_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoteMemoPanel.this.checkAndUpdate(NoteMemoPanel.this.comment_.getText(), SgfId.COMMENT);
            }
        });
    }

    private void checkAndUpdate(String newDatum, SgfId sgfId) {
        Property property = this.nodeView_.getProperty(sgfId);
        String lastString = property != null ? property.value().getString() : "";
        int charLength = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE);
        if (charLength <= Strings.calcDiffSize(lastString, newDatum)) {
            this.update(newDatum, sgfId);
        }
    }

    private void update(String newDatum, SgfId sgfId) {
        if (this.isModelUpdateMode_) {
            return;
        }
        UpdateProperty command = CommandFactory.createUpdateProperty(newDatum, sgfId, this.nodeView_, false);
        if (command != null) {
            this.eventBroker_.executeCommand(command);
        }
    }

    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void dispose() {
        this.nodeName_.dispose();
        this.comment_.dispose();
        this.eventBroker_ = EventBroker.NULL_BROKER;
    }

    public void changeHandlerPhase(HandlerPhase status) {
    }

    private class Adapter
    implements ModelEventNotifier,
    NodeMonitor,
    ControllerStatusMonitor {
        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            NoteMemoPanel.this.eventBroker_.removeView(NoteMemoPanel.this);
            NoteMemoPanel.this.eventBroker_ = eventBroker;
            NoteMemoPanel.this.eventBroker_.addView(NoteMemoPanel.this);
        }

        public void currentChanged(NodeView nodeView) {
            String newString;
            ArgumentChecker.throwIfNull((Object)nodeView);
            NoteMemoPanel.this.isModelUpdateMode_ = true;
            NoteMemoPanel.this.nodeView_ = nodeView;
            Property property = NoteMemoPanel.this.nodeView_.getProperty(SgfId.COMMENT);
            String string = newString = property == null ? "" : property.value().getString();
            if (!newString.equals(NoteMemoPanel.this.comment_.getText())) {
                NoteMemoPanel.this.comment_.setText(newString);
            }
            String string2 = newString = (property = NoteMemoPanel.this.nodeView_.getProperty(SgfId.NODENAME)) == null ? "" : property.value().getString();
            if (!newString.equals(NoteMemoPanel.this.nodeName_.getText())) {
                NoteMemoPanel.this.nodeName_.setText(newString);
            }
            NoteMemoPanel.this.isModelUpdateMode_ = false;
        }

        public void setEditMode(boolean isEditMode) {
            NoteMemoPanel.this.nodeName_.setEditable(isEditMode);
            NoteMemoPanel.this.comment_.setEditable(isEditMode);
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

