/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.dr.DrillEditorPanel;
import org.unitarou.yukinoshita.view.jface.ns.NodeSelectorPanel;
import org.unitarou.yukinoshita.view.jface.pa.ProblemActionPanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListControllerPanel
implements Adaptable,
WidgetContainer {
    private final Map<String, SelectablePanel> panelMap_;
    private StackLayout stackLayout4Node_;
    private GameType gameType_;
    private boolean isEditing_;
    private final Adapter adapter_;

    public NodeListControllerPanel() {
        NodeSelectorPanel nodeSelectorPanel = new NodeSelectorPanel();
        ProblemActionPanel problemActionPanel = new ProblemActionPanel();
        DrillEditorPanel drillEditorPanel = new DrillEditorPanel();
        this.panelMap_ = new HashMap<String, SelectablePanel>();
        this.panelMap_.put(this.makeKey(GameType.GAME, false), nodeSelectorPanel);
        this.panelMap_.put(this.makeKey(GameType.GAME, true), nodeSelectorPanel);
        this.panelMap_.put(this.makeKey(GameType.PROBLEM, false), problemActionPanel);
        this.panelMap_.put(this.makeKey(GameType.PROBLEM, true), nodeSelectorPanel);
        this.panelMap_.put(this.makeKey(GameType.DRILL, true), drillEditorPanel);
        this.stackLayout4Node_ = null;
        this.gameType_ = GameType.GAME;
        this.isEditing_ = false;
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        SelectablePanel panel2;
        Composite nodePanel = new Composite(parent, 0);
        this.stackLayout4Node_ = new StackLayout();
        nodePanel.setLayout(this.stackLayout4Node_);
        for (SelectablePanel panel2 : this.panelMap_.values()) {
            panel2.createContents(nodePanel);
        }
        panel2 = this.panelMap_.get(this.makeKey());
        this.stackLayout4Node_.topControl = panel2 != null ? panel2.getControl() : null;
        return nodePanel;
    }

    @Override
    public void dispose() {
        for (SelectablePanel panel : this.panelMap_.values()) {
            panel.dispose();
        }
    }

    private void updateNodePanel() {
        SelectablePanel panel = this.panelMap_.get(this.makeKey());
        if (panel != null) {
            this.stackLayout4Node_.topControl = panel.getControl();
            panel.getControl().getParent().layout();
        } else {
            this.stackLayout4Node_.topControl = null;
        }
    }

    private String makeKey(GameType gameType, boolean isEditing) {
        return gameType + String.valueOf(isEditing);
    }

    private String makeKey() {
        return this.makeKey(this.gameType_, this.isEditing_);
    }

    private class Adapter
    extends TieredModelEventNotifier
    implements GameMonitor,
    ControllerStatusMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        Adapter() {
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            NodeListControllerPanel.this.gameType_ = gameMediator.getGameType();
            NodeListControllerPanel.this.updateNodePanel();
        }

        protected Adaptable[] getAdaptables() {
            return NodeListControllerPanel.this.panelMap_.values().toArray(new Adaptable[NodeListControllerPanel.this.panelMap_.size()]);
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(NodeListControllerPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(NodeListControllerPanel.this);
            super.setEventBroker(eventBroker);
        }

        public void setEditMode(boolean isEditMode) {
            NodeListControllerPanel.this.isEditing_ = isEditMode;
            NodeListControllerPanel.this.updateNodePanel();
        }

        public void changeHandlerPhase(HandlerPhase status) {
        }
    }
}

