/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerStatusActions
implements Adaptable {
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Map<HandlerPhase, StatusChangeAction> actionMap_ = new HashMap<HandlerPhase, StatusChangeAction>();
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public Action[] getActions() {
        StateHandler stateHandler = this.eventBroker_.getCurrentStateHander();
        if (stateHandler == null) {
            return new Action[0];
        }
        HandlerPhase[] phases = stateHandler.getHandlerPhases();
        ArrayList<StatusChangeAction> list = new ArrayList<StatusChangeAction>(phases.length);
        int i = 0;
        while (i < phases.length) {
            list.add(this.getOrMakeAction(phases[i]));
            ++i;
        }
        return list.toArray(new Action[list.size()]);
    }

    public void setEventBroker(EventBroker eventBroker) {
        this.adapter_.setEventBroker(eventBroker);
    }

    private StatusChangeAction getOrMakeAction(HandlerPhase handlerPhase) {
        StatusChangeAction action = this.actionMap_.get(handlerPhase);
        if (action == null) {
            action = new StatusChangeAction(handlerPhase);
            this.actionMap_.put(handlerPhase, action);
        }
        return action;
    }

    private class StatusChangeAction
    extends Action {
        private final HandlerPhase handlerStatus_;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !StatusChangeAction.class.desiredAssertionStatus();
        }

        StatusChangeAction(HandlerPhase handlerStatus) {
            super(handlerStatus.displayName(), 8);
            if (!$assertionsDisabled && handlerStatus == null) {
                throw new AssertionError();
            }
            this.handlerStatus_ = handlerStatus;
            this.setId(handlerStatus.displayName());
            this.setEnabled(false);
        }

        public void run() {
            if (this.isChecked()) {
                HandlerStatusActions.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(this.handlerStatus_));
            }
        }
    }

    private class Adapter
    implements ModelEventNotifier,
    ControllerStatusMonitor {
        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            HandlerStatusActions.this.eventBroker_.removeView(HandlerStatusActions.this);
            HandlerStatusActions.this.eventBroker_ = eventBroker;
            HandlerStatusActions.this.eventBroker_.addView(HandlerStatusActions.this);
        }

        public void setEditMode(boolean isEditMode) {
            for (StatusChangeAction action : HandlerStatusActions.this.actionMap_.values()) {
                action.setEnabled(false);
                action.setChecked(false);
            }
            StateHandler stateHandler = HandlerStatusActions.this.eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            HandlerPhase[] phases = stateHandler.getHandlerPhases();
            int i = 0;
            while (i < phases.length) {
                HandlerStatusActions.this.getOrMakeAction(phases[i]).setEnabled(true);
                ++i;
            }
            if (phases.length != 0) {
                StatusChangeAction select = (StatusChangeAction)HandlerStatusActions.this.actionMap_.get(phases[0]);
                select.setChecked(true);
            }
        }

        public void changeHandlerPhase(HandlerPhase phase) {
            StateHandler stateHandler = HandlerStatusActions.this.eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            HandlerPhase[] phases = stateHandler.getHandlerPhases();
            int i = 0;
            while (i < phases.length) {
                StatusChangeAction action = HandlerStatusActions.this.getOrMakeAction(phases[i]);
                action.setChecked(phase.equals(phases[i]));
                ++i;
            }
        }
    }
}

