/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.gi.GiLine;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoPlainPanel
implements Adaptable,
WidgetContainer,
ModelEventNotifier {
    private String id_ = "";
    private GameType gameType_ = GameType.GAME;
    private ScrolledComposite scrolledComposite_ = null;
    private Composite composite_ = null;
    private final List<GiLine> giLines_ = new ArrayList<GiLine>();
    private final Adapter adapter_ = new Adapter();
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        this.scrolledComposite_ = new ScrolledComposite(parent, 512);
        this.composite_ = new Composite(this.scrolledComposite_, 0);
        this.scrolledComposite_.setContent(this.composite_);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.composite_.setLayout(gridLayout);
        for (GiLine giLine : this.giLines_) {
            Control control = giLine.createContents(this.composite_);
            GridData gridData = new GridData(1, 1, false, false);
            control.setLayoutData(gridData);
        }
        this.composite_.pack();
        Point point = Geometry.getSize(this.scrolledComposite_.getClientArea());
        this.scrolledComposite_.setMinSize(point);
        this.scrolledComposite_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GameInfoPlainPanel.this.resized();
            }
        });
        return this.scrolledComposite_;
    }

    private void resized() {
        this.composite_.pack();
        Point point = Geometry.getSize(this.scrolledComposite_.getClientArea());
        this.scrolledComposite_.setMinSize(point);
        for (GiLine giLine : this.giLines_) {
            Control control = giLine.getControl();
            GridData gridData = new GridData(1, 1, false, false);
            gridData.widthHint = point.x - 4;
            gridData.heightHint = -1;
            control.setLayoutData(gridData);
            giLine.setWidth(gridData.widthHint);
        }
        this.scrolledComposite_.layout(true, true);
    }

    @Override
    public void dispose() {
        if (this.composite_ == null) {
            return;
        }
        this.scrolledComposite_.dispose();
        this.scrolledComposite_ = null;
        this.composite_ = null;
        this.giLines_.clear();
        this.id_ = "";
        this.gameType_ = GameType.GAME;
    }

    public Control getControl() {
        return this.composite_.getParent();
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String id) {
        ArgumentChecker.throwIfNull((Object)id);
        this.id_ = id;
    }

    public GameType getGameType() {
        return this.gameType_;
    }

    public void setGameTypeId(String type) {
        ArgumentChecker.throwIfNull((Object)type);
        try {
            this.gameType_ = GameType.parse(type);
        }
        catch (TypeParseException e) {
            e.printStackTrace();
        }
    }

    public void addLine(GiLine giLine) {
        ArgumentChecker.throwIfNull((Object)giLine);
        this.giLines_.add(giLine);
    }

    public void setLabel(Properties properties) {
        ArgumentChecker.throwIfNull((Object)properties);
        for (GiLine giLine : this.giLines_) {
            giLine.setLabel(properties);
        }
    }

    @Override
    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_.removeView(this);
        this.eventBroker_ = eventBroker;
        this.eventBroker_.addView(this);
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor {
        Adapter() {
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            NodeList nodeList = gameMediator.getNodeList();
            int index = gameMediator.getCurrentNodeIndex();
            while (index >= 0) {
                NodeView nodeView = nodeList.getNodeView(index);
                if (nodeView.containsPropertyType(PropertyType.GAME_INFO)) {
                    this.currentChanged(nodeView);
                    return;
                }
                --index;
            }
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            for (GiLine giLine : GameInfoPlainPanel.this.giLines_) {
                giLine.currentChanged(nodeView);
            }
            GameInfoPlainPanel.this.resized();
        }
    }
}

