/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.io.Ios;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;

class SwtFileChooser
implements IgoFileChooser {
    private static File lastFolder_s_ = Ios.getCurrentDirectory();
    private final IgoFileChooser.Style style_;
    private final FileDialog fileDialog_;

    SwtFileChooser(Shell parent, IgoFileChooser.Style style) {
        int styleValue;
        ArgumentChecker.throwIfNull((Object)parent, (Object)style);
        this.style_ = style;
        switch (style) {
            case OPEN_FILE: {
                styleValue = 4096;
                break;
            }
            case OPEN_FILES: {
                styleValue = 4098;
                break;
            }
            case SAVE_FILE: {
                styleValue = 8192;
                break;
            }
            default: {
                styleValue = 0;
                assert (false) : "Unknown type :" + (Object)((Object)style);
                break;
            }
        }
        this.fileDialog_ = new FileDialog(parent, styleValue | 0x10000);
        this.fileDialog_.setFilterPath(lastFolder_s_.getAbsolutePath());
    }

    public boolean chooseFile() {
        boolean ret = this.fileDialog_.open() != null;
        lastFolder_s_ = this.getFolder();
        return ret;
    }

    public File getFolder() {
        File file = new File(this.fileDialog_.getFilterPath());
        while (file != null && !file.isDirectory()) {
            file = file.getParentFile();
        }
        return file == null ? Ios.getCurrentDirectory() : file;
    }

    public File getFile() {
        String filename = this.fileDialog_.getFileName();
        return filename.length() != 0 ? new File(this.fileDialog_.getFilterPath(), filename) : null;
    }

    public File[] getFiles() {
        String[] filenames = this.fileDialog_.getFileNames();
        ArrayList<File> ret = new ArrayList<File>(filenames.length);
        String[] stringArray = filenames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String filename = stringArray[n];
            ret.add(new File(this.fileDialog_.getFilterPath(), filename));
            ++n;
        }
        return ret.toArray(new File[ret.size()]);
    }

    public void setFile(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        this.fileDialog_.setFileName(file.getName());
    }

    public void setFileName(String filename) {
        ArgumentChecker.throwIfNull((Object)filename);
        this.fileDialog_.setFileName(filename);
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Argument must be a directory:" + file);
        }
        this.fileDialog_.setFilterPath(file.getAbsolutePath());
    }

    public void setFilter(NamedFileFilter[] filters) {
        ArgumentChecker.throwIfNull((Object)filters);
        String[] filterNames = new String[filters.length];
        String[] filterExts = new String[filters.length];
        int i = 0;
        while (i < filters.length) {
            filterNames[i] = filters[i].displayName();
            String[] wildcards = filters[i].getWildcards();
            StringBuilder builder = new StringBuilder();
            String[] stringArray = wildcards;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String wildcard = stringArray[n];
                builder.append(wildcard).append(", ");
                ++n;
            }
            if (wildcards.length != 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            filterExts[i] = builder.toString();
            ++i;
        }
        this.fileDialog_.setFilterNames(filterNames);
        this.fileDialog_.setFilterExtensions(filterExts);
    }

    public Shell getParent() {
        return this.fileDialog_.getParent();
    }

    public IgoFileChooser.Style getStyle() {
        return this.style_;
    }

    public String getText() {
        return this.fileDialog_.getText();
    }

    public void setText(String string) {
        this.fileDialog_.setText(string);
    }
}

