/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.util.filter.InsertLineSeparatorFilter;
import org.unitarou.sgf.util.filter.RemoveSoftLineBreakFilter;
import org.unitarou.sgf.util.filter.RemoveUtrFilter;
import org.unitarou.sgf.util.filter.SieveBySgfIdFilter;
import org.unitarou.swt.EnumCombo;
import org.unitarou.swt.EnumSelectionAdapter;
import org.unitarou.swt.EnumSelectionListener;
import org.unitarou.swt.LabeledEnumCombo;
import org.unitarou.swt.Swts;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.NestedFilter;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfTextDialog
extends Dialog {
    private static final int COPY_ID = 1024;
    private static final int CANCEL_ID = 1;
    private static final MessageResource LB_DIALOG_TITLE = new MessageResource(SgfTextDialog.class, "lbDialogTitle");
    private static final MessageResource CLB_COPY = new MessageResource(SgfTextDialog.class, "clbCopy");
    private static final MessageResource CLB_GROUP_FILTER_OPTION = new MessageResource(SgfTextDialog.class, "clbGroupFilterOption");
    private static final MessageResource CLB_UTR_COMBO = new MessageResource(SgfTextDialog.class, "clbUtrCombo");
    private static final MessageResource CLB_SGFID_OPTION = new MessageResource(SgfTextDialog.class, "clbSgfidOption");
    private static final MessageResource LB_LINE_SIZE = new MessageResource(SgfTextDialog.class, "lbLineSize");
    private static final Set<SgfId> requisiteIds_;
    private final org.unitarou.sgf.Collection collection_;
    private final int activeGameIndex_;
    private SgfId[] sgfIds_;
    private RemoveUtrFilter.Option utrType_;
    private final EnumSet<InsertLineSeparatorFilter.Option> slbOptions_;
    private LabeledEnumCombo<RemoveUtrFilter.Option> utrCombo_;
    private LabeledEnumCombo<HandleSgfId> sgfIdCombo_;
    private Text text_;
    private CheckboxTableViewer rgtViewer_;
    private CheckboxTableViewer sgfIdViewer_;
    private Label lbLineSize_;
    private Scale scale_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(SgfId.GAME_TYPE, SgfId.SIZE, SgfId.RESULT, SgfId.PLAYER_WHITE, SgfId.PLAYER_BLACK, SgfId.KOMI, SgfId.HANDICAP, SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY, SgfId.WHITE, SgfId.BLACK));
        requisiteIds_ = Collections.unmodifiableSet(set);
    }

    public SgfTextDialog(Shell parentShell, org.unitarou.sgf.Collection collection, int activeGameIndex) {
        super(parentShell);
        ArgumentChecker.throwIfNull((Object)collection);
        ArgumentChecker.throwIfNegative(activeGameIndex);
        this.setShellStyle(65584);
        this.collection_ = collection;
        this.activeGameIndex_ = activeGameIndex;
        this.utrType_ = RemoveUtrFilter.Option.REMOVE_ALL;
        this.slbOptions_ = EnumSet.noneOf(InsertLineSeparatorFilter.Option.class);
        this.utrCombo_ = new LabeledEnumCombo<RemoveUtrFilter.Option>(EnumSet.allOf(RemoveUtrFilter.Option.class), EnumSet.of(EnumCombo.Style.READ_ONLY));
        this.utrCombo_.setText(CLB_UTR_COMBO.get());
        this.utrCombo_.addListener((EnumSelectionListener<RemoveUtrFilter.Option>)new EnumSelectionAdapter<RemoveUtrFilter.Option>(){

            @Override
            public void itemSelected(RemoveUtrFilter.Option item) {
                SgfTextDialog.this.utrType_ = item;
                SgfTextDialog.this.updateText();
            }
        });
        this.sgfIdCombo_ = new LabeledEnumCombo<HandleSgfId>(EnumSet.allOf(HandleSgfId.class), EnumSet.of(EnumCombo.Style.READ_ONLY));
        this.sgfIdCombo_.setText(CLB_SGFID_OPTION.get());
        this.sgfIdCombo_.addListener((EnumSelectionListener<HandleSgfId>)new EnumSelectionAdapter<HandleSgfId>(){

            @Override
            public void itemSelected(HandleSgfId item) {
                SgfTextDialog.this.updateSgfIdType(item);
                SgfTextDialog.this.updateText();
            }
        });
        this.text_ = null;
        this.rgtViewer_ = null;
        this.sgfIdViewer_ = null;
        this.lbLineSize_ = null;
        this.scale_ = null;
        HashSet<SgfId> sgfIdSet = new HashSet<SgfId>();
        for (RootGameTree rgt : this.collection_) {
            this.addAllSgfId(rgt, sgfIdSet);
        }
        this.sgfIds_ = sgfIdSet.toArray(new SgfId[sgfIdSet.size()]);
        Arrays.sort(this.sgfIds_);
    }

    private void updateSgfIdType(HandleSgfId handleSgfId) {
        switch (handleSgfId) {
            case MANUAL: {
                TableItem[] tableItemArray = this.sgfIdViewer_.getTable().getItems();
                int n = 0;
                int n2 = tableItemArray.length;
                while (n < n2) {
                    TableItem tableItem = tableItemArray[n];
                    tableItem.setGrayed(false);
                    ++n;
                }
                break;
            }
            case ALL: {
                TableItem[] tableItemArray = this.sgfIdViewer_.getTable().getItems();
                int n = 0;
                int n3 = tableItemArray.length;
                while (n < n3) {
                    TableItem tableItem = tableItemArray[n];
                    tableItem.setChecked(true);
                    tableItem.setGrayed(true);
                    ++n;
                }
                break;
            }
            case REQUISITE: {
                TableItem[] tableItemArray = this.sgfIdViewer_.getTable().getItems();
                int n = 0;
                int n4 = tableItemArray.length;
                while (n < n4) {
                    TableItem tableItem = tableItemArray[n];
                    tableItem.setChecked(requisiteIds_.contains(tableItem.getData()));
                    tableItem.setGrayed(true);
                    ++n;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void updateSgfIds() {
        org.unitarou.sgf.Collection collection = new org.unitarou.sgf.Collection();
        for (RootGameTree rgt : this.collection_) {
            if (!this.rgtViewer_.getChecked(rgt)) continue;
            collection.addLast(rgt);
        }
        HashSet<SgfId> sgfIdSet = new HashSet<SgfId>();
        for (RootGameTree rgt : collection) {
            this.addAllSgfId(rgt, sgfIdSet);
        }
        HashSet uncheckedIds = new HashSet(Arrays.asList(this.sgfIds_));
        uncheckedIds.removeAll((Collection)Arrays.asList(this.sgfIdViewer_.getCheckedElements()));
        this.sgfIdViewer_.remove(this.sgfIds_);
        this.sgfIds_ = sgfIdSet.toArray(new SgfId[sgfIdSet.size()]);
        Arrays.sort(this.sgfIds_);
        this.sgfIdViewer_.add(this.sgfIds_);
        HashSet checkedIds = new HashSet(Arrays.asList(this.sgfIds_));
        checkedIds.removeAll(uncheckedIds);
        this.sgfIdViewer_.setCheckedElements(checkedIds.toArray());
        this.updateSgfIdType((HandleSgfId)((Object)this.sgfIdCombo_.getSelected()));
    }

    private void addAllSgfId(GameTree gameTree, Set<SgfId> sgfIdSet) {
        for (Node node : gameTree.getSequence()) {
            Property[] propertyArray = node.getProperties();
            int n = 0;
            int n2 = propertyArray.length;
            while (n < n2) {
                Property property = propertyArray[n];
                sgfIdSet.add(property.sgfId());
                ++n;
            }
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = 0;
        int n3 = gameTreeArray.length;
        while (n < n3) {
            GameTree child = gameTreeArray[n];
            this.addAllSgfId(child, sgfIdSet);
            ++n;
        }
    }

    private void updateText() {
        ArrayList<SgfId> list = new ArrayList<SgfId>();
        Object[] objectArray = this.sgfIdViewer_.getCheckedElements();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object object = objectArray[n];
            list.add((SgfId)object);
            ++n;
        }
        SgfId[] includes = list.toArray(new SgfId[list.size()]);
        org.unitarou.sgf.Collection collection = new org.unitarou.sgf.Collection();
        int i = 0;
        while (i < this.collection_.size()) {
            if (this.rgtViewer_.getChecked(this.collection_.get(i))) {
                collection.addLast(this.collection_.get(i));
            }
            ++i;
        }
        NestedFilter filter = new RemoveSoftLineBreakFilter(new SieveBySgfIdFilter(includes));
        RemoveUtrFilter removeUtrFilter = new RemoveUtrFilter(filter);
        removeUtrFilter.setOption(this.utrType_);
        filter = removeUtrFilter;
        InsertLineSeparatorFilter ilsFilter = new InsertLineSeparatorFilter(filter, this.scale_.getSelection());
        ilsFilter.setOption(this.slbOptions_);
        filter = ilsFilter;
        collection = filter.filter(collection);
        String formatted = new SgfFormatter().formatAsString(collection);
        this.text_.setText(Swts.toWidgetText(formatted));
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(LB_DIALOG_TITLE.get());
        GridData gridData = (GridData)parent.getLayoutData();
        gridData.heightHint = 480;
        gridData.widthHint = 640;
        Composite frame = (Composite)super.createDialogArea(parent);
        this.createTextArea(frame);
        this.createSliderArea(frame);
        this.updateText();
        return frame;
    }

    private void createTextArea(Composite parent) {
        USashForm sashForm = WidgetFactory.createUSashForm(parent, 256);
        GridData gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData(gridData);
        this.text_ = new Text(sashForm, 2818);
        this.createControlArea(sashForm);
        sashForm.setWeights(new int[]{1, -220});
    }

    private void createControlArea(Composite parent) {
        USashForm sashForm = WidgetFactory.createUSashForm(parent, 512);
        Composite composite = new Composite(sashForm, 0);
        composite.setLayout(new GridLayout());
        this.rgtViewer_ = CheckboxTableViewer.newCheckList(composite, 68356);
        this.rgtViewer_.setLabelProvider(new RgtLabelProvider());
        int i = 0;
        while (i < this.collection_.size()) {
            RootGameTree rgt = this.collection_.get(i);
            this.rgtViewer_.add(rgt);
            if (i == this.activeGameIndex_) {
                this.rgtViewer_.setChecked(rgt, true);
            }
            ++i;
        }
        GridData gridData = new GridData(4, 4, true, true);
        this.rgtViewer_.getTable().setLayoutData(gridData);
        this.rgtViewer_.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SgfTextDialog.this.updateSgfIds();
                SgfTextDialog.this.updateText();
            }
        });
        this.createFilterControllerArea(composite);
        this.createSgfIdControllerArea(sashForm);
        sashForm.setWeights(new int[]{2, 3});
    }

    private void createFilterControllerArea(Composite parent) {
        Group group = new Group(parent, 16);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData(gridData);
        group.setText(CLB_GROUP_FILTER_OPTION.get());
        group.setLayout(new RowLayout(512));
        this.utrCombo_.createContents(group);
        this.utrCombo_.select(this.utrType_);
        this.createUseSlb(group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_TEXT);
        this.createUseSlb(group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_SIMPLETEXT);
    }

    private void createUseSlb(Composite parent, final InsertLineSeparatorFilter.Option option) {
        final Button button = new Button(parent, 32);
        button.setText(option.toString());
        button.setSelection(this.slbOptions_.contains((Object)option));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    SgfTextDialog.this.slbOptions_.add(option);
                } else {
                    SgfTextDialog.this.slbOptions_.remove((Object)option);
                }
                SgfTextDialog.this.updateText();
            }
        });
    }

    private void createSgfIdControllerArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout(gridLayout);
        this.sgfIdCombo_.createContents(composite);
        this.sgfIdViewer_ = CheckboxTableViewer.newCheckList(composite, 68356);
        this.sgfIdViewer_.setLabelProvider(new SgfIdLabelProvider());
        Table table = this.sgfIdViewer_.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData(gridData);
        table.setHeaderVisible(false);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        this.sgfIdViewer_.add(this.sgfIds_);
        this.sgfIdViewer_.setAllChecked(true);
        this.sgfIdViewer_.setAllGrayed(false);
        this.sgfIdViewer_.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SgfTextDialog.this.updateText();
            }
        });
        TableColumn[] tableColumnArray = table.getColumns();
        int n = 0;
        int n2 = tableColumnArray.length;
        while (n < n2) {
            TableColumn column = tableColumnArray[n];
            column.pack();
            ++n;
        }
        this.lbLineSize_ = new Label(composite, 0);
        gridData = new GridData(4, 1024, true, false);
        this.lbLineSize_.setLayoutData(gridData);
    }

    private void createSliderArea(Composite parent) {
        this.scale_ = new Scale(parent, 256);
        GridData gridData = new GridData(4, 1024, true, false);
        this.scale_.setLayoutData(gridData);
        this.scale_.setMinimum(10);
        this.scale_.setMaximum(100);
        this.scale_.setSelection(40);
        this.scale_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SgfTextDialog.this.lbLineSize_.setText(LB_LINE_SIZE.get((Object)String.valueOf(SgfTextDialog.this.scale_.getSelection())));
                SgfTextDialog.this.updateText();
            }
        });
        this.lbLineSize_.setText(LB_LINE_SIZE.get((Object)String.valueOf(this.scale_.getSelection())));
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, CLB_COPY.get(), false);
        this.createButton(parent, 1, BasicMessages.LB_CANCEL.get(), true);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                Clipboard cb = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{this.text_.getText()}, new Transfer[]{textTransfer});
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HandleSgfId {
        MANUAL,
        ALL,
        REQUISITE;


        public String toString() {
            return new MessageResource(((Object)((Object)this)).getClass(), this.name()).get();
        }
    }

    private class RgtLabelProvider
    extends LabelProvider {
        static /* synthetic */ Class class$0;

        RgtLabelProvider() {
        }

        public String getText(Object element) {
            RootGameTreeLabelProvider provider = Yukinoshita.context().getProvider(RootGameTreeLabelProvider.class, null);
            return provider.getLabel((RootGameTree)element);
        }
    }

    private class SgfIdLabelProvider
    implements ITableLabelProvider {
        SgfIdLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof SgfId)) {
                return "";
            }
            SgfId sgfId = (SgfId)element;
            switch (columnIndex) {
                case 0: {
                    return sgfId.id();
                }
                case 1: {
                    return sgfId.displayName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

