/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.provider.clp.ForFileNameCollectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTargetFileDialog
extends UTitleAreaDialog {
    private static final MessageResource LB_NEW_FILE = new MessageResource(SelectTargetFileDialog.class, "lbNewFile");
    private static final MessageResource LB_UNSAVED = new MessageResource(SelectTargetFileDialog.class, "lbUnsaved");
    private static final MessageResource LB_EDIT_MODE_ONLY = new MessageResource(SelectTargetFileDialog.class, "lbEditModeOnly");
    private static final MessageResource NT_YOU_CAN_SELECT_THESE_FILES = new MessageResource(SelectTargetFileDialog.class, "ntYouCanSelectTheseFiles");
    private static final String TYPE_SEPARATOR = "/";
    private EnumSet<Type> typeSet_;
    private GameFrameController target_;
    private String targetCategoryCaption_;
    static /* synthetic */ Class class$0;

    public SelectTargetFileDialog(Shell parentShell) {
        this(parentShell, EnumSet.of(Type.PERMITS_NEW_FILE));
    }

    public SelectTargetFileDialog(Shell parentShell, EnumSet<Type> typeSet) {
        super(parentShell);
        ArgumentChecker.throwIfNull(typeSet);
        this.setShellStyle(32816);
        this.typeSet_ = EnumSet.copyOf(typeSet);
        this.target_ = null;
        this.targetCategoryCaption_ = "";
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setMessage(this.composeMessage());
        return control;
    }

    private String composeMessage() {
        String editCondtionMsg;
        StringBuilder builder = new StringBuilder();
        String string = editCondtionMsg = this.typeSet_.contains((Object)Type.PERMITS_NO_EDIT_MODE) ? "" : LB_EDIT_MODE_ONLY.get();
        if (this.typeSet_.contains((Object)Type.PERMITS_NEW_FILE)) {
            builder.append(LB_NEW_FILE.get()).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_GAME)) {
            builder.append(GameType.GAME.displayName()).append(editCondtionMsg).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_PROBLEM)) {
            builder.append(GameType.PROBLEM.displayName()).append(editCondtionMsg).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_DRILL)) {
            builder.append(GameType.DRILL.displayName()).append(editCondtionMsg).append(TYPE_SEPARATOR);
        }
        if (builder.length() != 0) {
            builder.delete(builder.length() - TYPE_SEPARATOR.length(), builder.length());
            builder.insert(0, Strings.LINE_SEPARATOR).insert(0, NT_YOU_CAN_SELECT_THESE_FILES.get());
        }
        return builder.toString();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite frame = (Composite)super.createDialogArea(parent);
        Group group_ = new Group(frame, 16);
        group_.setLayout(new RowLayout(512));
        group_.setText(this.targetCategoryCaption_);
        ButtonSelected listener = new ButtonSelected();
        if (this.typeSet_.contains((Object)Type.PERMITS_NEW_FILE)) {
            Button button = new Button(group_, 16);
            button.setText(LB_NEW_FILE.get());
            button.setData(null);
            button.addSelectionListener(listener);
        }
        boolean permitsNoEditMode = this.typeSet_.contains((Object)Type.PERMITS_NO_EDIT_MODE);
        ForFileNameCollectionProvider provider = new ForFileNameCollectionProvider();
        GameFrameController[] gameFrameControllerArray = this.findTargets();
        int n = 0;
        int n2 = gameFrameControllerArray.length;
        while (n < n2) {
            GameFrameController gfc = gameFrameControllerArray[n];
            Button button = new Button(group_, 16);
            button.setData(gfc);
            button.setEnabled(permitsNoEditMode || gfc.isEditMode());
            button.addSelectionListener(listener);
            File file = gfc.getCollection().getFile();
            if (file == null) {
                button.setText(LB_UNSAVED.get((Object)provider.getLabel(gfc.getCollection())));
            } else {
                button.setText(file.getName());
            }
            ++n;
        }
        return frame;
    }

    private GameFrameController[] findTargets() {
        ArrayList<GameFrameController> gfcList = new ArrayList<GameFrameController>();
        WindowController[] windowControllerArray = Yukinoshita.application().getAllController();
        int n = 0;
        int n2 = windowControllerArray.length;
        while (n < n2) {
            GameFrameController[] gfcs;
            WindowController controller = windowControllerArray[n];
            GameFrameController[] gameFrameControllerArray = gfcs = controller.getGameFrameControllers();
            int n3 = 0;
            int n4 = gameFrameControllerArray.length;
            while (n3 < n4) {
                block4: {
                    Collection collection;
                    GameFrameController gfc;
                    block5: {
                        gfc = gameFrameControllerArray[n3];
                        collection = gfc.getCollection();
                        if (collection.size() == 0) break block4;
                        GameType gameType = collection.get(0).getGameType();
                        if (!GameType.DRILL.equals(gameType)) break block5;
                        if (!this.typeSet_.contains((Object)Type.PERMITS_DRILL)) break block4;
                        gfcList.add(gfc);
                        break block4;
                    }
                    for (RootGameTree rgt : collection) {
                        if (GameType.GAME.equals(rgt.getGameType()) && this.typeSet_.contains((Object)Type.PERMITS_GAME)) {
                            gfcList.add(gfc);
                            break;
                        }
                        if (!GameType.PROBLEM.equals(rgt.getGameType()) || !this.typeSet_.contains((Object)Type.PERMITS_PROBLEM)) continue;
                        gfcList.add(gfc);
                        break;
                    }
                }
                ++n3;
            }
            ++n;
        }
        return gfcList.toArray(new GameFrameController[gfcList.size()]);
    }

    public void setTargetCategoryCaption(String text) {
        ArgumentChecker.throwIfNull((Object)text);
        this.targetCategoryCaption_ = text;
    }

    public GameFrameController getTarget() {
        return this.target_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PERMITS_NO_EDIT_MODE,
        PERMITS_NEW_FILE,
        PERMITS_GAME,
        PERMITS_PROBLEM,
        PERMITS_DRILL;

    }

    private class ButtonSelected
    extends SelectionAdapter {
        ButtonSelected() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectTargetFileDialog.this.target_ = (GameFrameController)e.widget.getData();
        }
    }
}

