/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.CollectionsPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;

public class RootGameTreeChooser
extends UTitleAreaDialog {
    private final Collection collection_;
    private final Style style_;
    private final CollectionsPanel<IgoOutlinePanel> collectionsPanel_;
    private IgoOutlinePanel[] panels_;

    public RootGameTreeChooser(Shell parentShell, Collection collection, Style style) {
        super(parentShell);
        ArgumentChecker.throwIfNull((Object)collection, (Object)style);
        this.setShellStyle(32816);
        this.collection_ = collection;
        this.style_ = style;
        this.collectionsPanel_ = new CollectionsPanel<IgoOutlinePanel>(IgoOutlinePanel.factory(), 3);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Button button = this.getButton(0);
        if (button == null) {
            throw new IllegalStateException("Can't find OK button.");
        }
        button.setEnabled(this.style_.equals((Object)Style.ANY));
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite frame = new Composite(composite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 500;
        gridData.heightHint = 300;
        frame.setLayoutData(gridData);
        frame.setLayout(new FillLayout());
        this.collectionsPanel_.createContents(frame);
        this.collectionsPanel_.set(new Collection[]{this.collection_});
        this.panels_ = this.collectionsPanel_.getPanels(new IgoOutlinePanel[0]);
        MouseListened listener = new MouseListened();
        IgoOutlinePanel[] igoOutlinePanelArray = this.panels_;
        int n = 0;
        int n2 = igoOutlinePanelArray.length;
        while (n < n2) {
            IgoOutlinePanel panel = igoOutlinePanelArray[n];
            panel.getBoardControl().addMouseListener(listener);
            ++n;
        }
        return composite;
    }

    public RootGameTree[] getSelected() {
        ArrayList<RootGameTree> ret = new ArrayList<RootGameTree>(this.panels_.length);
        IgoOutlinePanel[] igoOutlinePanelArray = this.panels_;
        int n = 0;
        int n2 = igoOutlinePanelArray.length;
        while (n < n2) {
            IgoOutlinePanel panel = igoOutlinePanelArray[n];
            if (panel.isFocused()) {
                ret.add(panel.getRootGameTree());
            }
            ++n;
        }
        return ret.toArray(new RootGameTree[ret.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        SINGLE,
        MULTI,
        ANY;

    }

    private class MouseListened
    extends MouseAdapter {
        MouseListened() {
        }

        public void mouseDown(MouseEvent e) {
            switch (RootGameTreeChooser.this.style_) {
                case SINGLE: {
                    IgoOutlinePanel[] igoOutlinePanelArray = RootGameTreeChooser.this.panels_;
                    int n = 0;
                    int n2 = igoOutlinePanelArray.length;
                    while (n < n2) {
                        IgoOutlinePanel panel = igoOutlinePanelArray[n];
                        panel.setFocus(panel.getBoardControl().equals(e.widget));
                        ++n;
                    }
                    RootGameTreeChooser.this.getButton(0).setEnabled(true);
                    break;
                }
                case MULTI: {
                    int selected = 0;
                    IgoOutlinePanel[] igoOutlinePanelArray = RootGameTreeChooser.this.panels_;
                    int n = 0;
                    int n3 = igoOutlinePanelArray.length;
                    while (n < n3) {
                        IgoOutlinePanel panel = igoOutlinePanelArray[n];
                        if (panel.getBoardControl().equals(e.widget)) {
                            panel.setFocus(!panel.isFocused());
                        }
                        selected += panel.isFocused() ? 1 : 0;
                        ++n;
                    }
                    RootGameTreeChooser.this.getButton(0).setEnabled(selected != 0);
                }
            }
        }
    }
}

