/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.List;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedFileFilter
extends WildcardFilter
implements NameDisplayable {
    private final String[] wildcards_;
    private final String fileTypeName_;

    public NamedFileFilter(String wildcard, String fileTypeName) {
        super(wildcard);
        ArgumentChecker.throwIfNull((Object)wildcard, (Object)fileTypeName);
        this.wildcards_ = new String[1];
        this.wildcards_[0] = wildcard;
        this.fileTypeName_ = fileTypeName;
    }

    public NamedFileFilter(String[] wildcards, String fileTypeName) {
        super(wildcards);
        ArgumentChecker.throwIfNull((Object)wildcards, (Object)fileTypeName);
        this.wildcards_ = new String[wildcards.length];
        System.arraycopy(wildcards, 0, this.wildcards_, 0, this.wildcards_.length);
        this.fileTypeName_ = fileTypeName;
    }

    public NamedFileFilter(List<String> wildcards, String fileTypeName) {
        super(wildcards);
        ArgumentChecker.throwIfNull(wildcards, (Object)fileTypeName);
        this.wildcards_ = wildcards.toArray(new String[wildcards.size()]);
        this.fileTypeName_ = fileTypeName;
    }

    @Override
    public String displayName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fileTypeName_).append(" (");
        String[] stringArray = this.wildcards_;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String suffix = stringArray[n];
            builder.append(suffix).append(", ");
            ++n;
        }
        builder.delete(builder.length() - 2, builder.length());
        if (this.wildcards_.length != 0) {
            builder.append(")");
        }
        return builder.toString();
    }

    public String[] getWildcards() {
        String[] ret = new String[this.wildcards_.length];
        System.arraycopy(this.wildcards_, 0, ret, 0, ret.length);
        return ret;
    }
}

