/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

public class AskSaveDialog
extends TitleAreaDialog {
    public static final int SAVE_ID = 1024;
    public static final int SAVEAS_ID = 1025;
    public static final int NOSAVE_ID = 1026;
    public static final int CANCEL_ID = 1;
    private static final MessageResource LB_CONFIRM_SAVE_FILE = new MessageResource(AskSaveDialog.class, "lbConfirmSaveFile");
    private static final MessageResource LB_ASK_SAVE_FILE = new MessageResource(AskSaveDialog.class, "lbAskSaveFile");
    private static final MessageResource LB_SAVE_FILE_PATH = new MessageResource(AskSaveDialog.class, "lbSaveFilePath");
    private static final MessageResource LB_NEW_FILE = new MessageResource(AskSaveDialog.class, "lbNewFile");
    private static final MessageResource CLB_SAVE = new MessageResource(AskSaveDialog.class, "clbSave");
    private static final MessageResource CLB_SAVEAS = new MessageResource(AskSaveDialog.class, "clbSaveAs");
    private static final MessageResource CLB_NOSAVE = new MessageResource(AskSaveDialog.class, "clbNoSave");
    private static final MessageResource CLB_CANCEL = new MessageResource(AskSaveDialog.class, "clbCancel");
    private static final MessageResource LB_CHANGE_MARK = new MessageResource(AskSaveDialog.class, "lbChangeMark");
    private static final MessageResource LB_NO_NAME = new MessageResource(AskSaveDialog.class, "lbNoName");
    private static final MessageResource LB_NUMBER = new MessageResource(AskSaveDialog.class, "lbNumber");
    private static final MessageResource LB_CHANGE = new MessageResource(AskSaveDialog.class, "lbChange");
    private static final MessageResource LB_GAME = new MessageResource(AskSaveDialog.class, "lbGame");
    private static final int COLS_BUTTON = 2;
    private final GameFrameController controller_;
    static /* synthetic */ Class class$0;

    public AskSaveDialog(Shell parentShell, GameFrameController controller) {
        super(parentShell);
        this.setShellStyle(65584);
        ArgumentChecker.throwIfNull((Object)parentShell, (Object)controller);
        this.controller_ = controller;
    }

    protected Control createContents(Composite parent) {
        File file = this.controller_.getCollection().getFile();
        String filePath = file != null ? file.getPath() : LB_NEW_FILE.get();
        Control control = super.createContents(parent);
        this.setTitle(LB_ASK_SAVE_FILE.get());
        this.setMessage(LB_SAVE_FILE_PATH.get((Object)filePath));
        Shell shell = this.getShell();
        shell.setText(LB_CONFIRM_SAVE_FILE.get());
        int height = Math.min(this.controller_.getCollection().size() * 10 + 200, 320);
        shell.setSize(480, height);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TableViewer tableViewer = new TableViewer(composite, 65536);
        tableViewer.setContentProvider(new CollectionContentsProvider());
        tableViewer.setLabelProvider(new CollectionLabelProvier());
        Table table = tableViewer.getTable();
        table.setLayoutData(new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        new TableColumn(table, 16384).setText(LB_CHANGE.get());
        new TableColumn(table, 0x1000000).setText(LB_NUMBER.get());
        new TableColumn(table, 0x1000000).setText(SgfId.GAME_TYPE.displayName());
        new TableColumn(table, 16384).setText(LB_GAME.get());
        tableViewer.setInput(this.controller_);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        ((GridLayout)parent.getLayout()).numColumns = 2;
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1024, CLB_SAVE.get(), false);
        button.setEnabled(this.controller_.getCollection().getFile() != null);
        this.createButton(parent, 1025, CLB_SAVEAS.get(), true);
        this.createButton(parent, 1026, CLB_NOSAVE.get(), false);
        this.createButton(parent, 1, CLB_CANCEL.get(), false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    private class CollectionContentsProvider
    implements IStructuredContentProvider {
        CollectionContentsProvider() {
        }

        public Object[] getElements(Object inputElement) {
            GameFrameController gfc = (GameFrameController)inputElement;
            if (GameType.DRILL.equals(gfc.getCollectionEditor().getCollection().get(0).getGameType())) {
                return new Integer[]{new Integer(0)};
            }
            Object[] ret = new Integer[gfc.getCollection().size()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = new Integer(i);
                ++i;
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CollectionLabelProvier
    implements ITableLabelProvider {
        static /* synthetic */ Class class$0;

        CollectionLabelProvier() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            int index = ((Number)element).intValue();
            Collection collection = AskSaveDialog.this.controller_.getCollection();
            RootGameTreeLabelProvider provider = Yukinoshita.context().getProvider(RootGameTreeLabelProvider.class, collection);
            RootGameTree rgt = collection.get(index);
            switch (columnIndex) {
                case 0: {
                    boolean[] flags = AskSaveDialog.this.controller_.getChangedFlags();
                    return flags[index] ? LB_CHANGE_MARK.get() : "";
                }
                case 1: {
                    return String.valueOf(index + 1);
                }
                case 2: {
                    return rgt.getGameType().displayName();
                }
                case 3: {
                    String gn = provider.getLabel(rgt);
                    return "".equals(gn) ? LB_NO_NAME.get() : gn;
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

