/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter;

public class SolidStoneVer1Painter
extends AbstractStonePainter {
    private static final MessageResource LB_DISPLAY_NAME = new MessageResource(SolidStoneVer1Painter.class, "lbDisplayName");
    private static final ColorResource COLOR_WHITE_BODY = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_BLACK_BODY = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_WHITE_LABEL = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_LABEL = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_LAST_LABEL = new ColorResource(255, 0, 0);
    private static final ColorResource COLOR_LAST = new ColorResource(204, 0, 0);
    private static final FontResource FONT_MOVE_NUMBER = new FontResource("Helvetica", 10, 1);
    static /* synthetic */ Class class$0;

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    protected ImageData createWhiteStone(Point boxSize) {
        return this.createStoneImage(boxSize, COLOR_WHITE_BODY.get(), 190);
    }

    protected ImageData createBlackStone(Point boxSize) {
        return this.createStoneImage(boxSize, COLOR_BLACK_BODY.get(), 0);
    }

    private ImageData createStoneImage(Point boxSize_, Color body, int colorShift) {
        ImageData imageData;
        Image img = null;
        GC imgGc = null;
        try {
            img = new Image(null, boxSize_.x, boxSize_.y);
            imgGc = new GC(img);
            imgGc.setBackground(COLOR_TRANSPARENT.get());
            imgGc.fillRectangle(img.getBounds());
            imgGc.setBackground(body);
            imgGc.fillOval(0, 0, boxSize_.x, boxSize_.y);
            int boundColor = -1;
            int size = boxSize_.x;
            int center = size / 2;
            double radius = center;
            while (radius >= 1.0) {
                int slide = (int)((double)center - radius);
                int c = (int)((double)slide / (double)size * 160.0 + (double)colorShift);
                if (255 < c) {
                    c = 255;
                }
                if (boundColor == -1) {
                    boundColor = c;
                }
                Color color = new Color(Display.getCurrent(), c, c, c);
                imgGc.setForeground(color);
                imgGc.setBackground(color);
                double axis = (int)((double)slide * 0.75);
                double radius1 = (double)size - (double)(slide * 4) / 3.0;
                int tl = (int)axis;
                int br = (int)(radius1 - axis);
                imgGc.fillOval(tl, tl, br, br);
                color.dispose();
                radius -= 1.0;
            }
            imgGc.setLineWidth(1);
            imgGc.setLineStyle(1);
            Color color = new Color(Display.getCurrent(), boundColor, boundColor, boundColor);
            imgGc.setForeground(color);
            imgGc.drawOval(0, 0, boxSize_.x - 1, boxSize_.y - 1);
            color.dispose();
            ImageData ret = img.getImageData();
            ret.transparentPixel = ret.getPixel(0, 0);
            imageData = ret;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(imgGc);
            Swts.disposeQuietly(img);
            throw throwable;
        }
        Swts.disposeQuietly(imgGc);
        Swts.disposeQuietly(img);
        return imageData;
    }

    protected void paintLabel(GC gc, Rectangle r, String label, SgfColor color, boolean isLastMove) {
        gc.setFont(FONT_MOVE_NUMBER.getInCircle(gc, label, r.width));
        Point p = gc.textExtent(label);
        Color fontColor = isLastMove ? COLOR_LAST_LABEL.get() : (SgfColor.BLACK.equals(color) ? COLOR_BLACK_LABEL.get() : COLOR_WHITE_LABEL.get());
        gc.setForeground(fontColor);
        gc.drawText(label, r.x + r.width / 2 - p.x / 2, r.y + r.height / 2 - p.y / 2, true);
    }

    protected void paintLastMoveMark(GC gc, Rectangle r, SgfColor color) {
        gc.setLineWidth(2);
        gc.setLineStyle(1);
        gc.setBackground(COLOR_LAST.get());
        Rectangle lastrect = Rectangles.createScaled(r, 0.4);
        gc.fillOval(lastrect.x, lastrect.y, lastrect.width, lastrect.height);
    }
}

