/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.MarkPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.CirclePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.CrossPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.DimPointsPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.Painter;
import org.unitarou.yukinoshita.view.jface.board.mp.SelectedPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.SquarePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TerritoryBlackPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TerritoryWhitePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.TrianglePainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMarkerPainter
implements MarkPainter {
    private static final ColorResource COLOR_VARIATION_FONT = new ColorResource(0, 102, 0);
    private static final ColorResource COLOR_LINE = new ColorResource(0, 102, 0);
    private static final ColorResource COLOR_LINE_NOGDI = new ColorResource(0, 153, 0);
    private static final ColorResource COLOR_LINE_NOGDI_TRANSIENT = new ColorResource(0, 255, 0);
    private static final FontResource FONT_VARIATION = new FontResource("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 24, 1);
    private static final FontResource FONT_LABEL = new FontResource("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 24, 1);
    private final SortedMap<SgfId, Painter> painterMap_ = new TreeMap<SgfId, Painter>();
    private final SgfId[] scope_;
    private final Set<SgfPoint> lastDd_;

    public SimpleMarkerPainter() {
        this.painterMap_.put(SgfId.MARK_WITH_X, new CrossPainter());
        this.painterMap_.put(SgfId.CIRCLE, new CirclePainter());
        this.painterMap_.put(SgfId.SQUARE, new SquarePainter());
        this.painterMap_.put(SgfId.TRIANGLE, new TrianglePainter());
        this.painterMap_.put(SgfId.SELECTED, new SelectedPainter());
        this.painterMap_.put(SgfId.TERRITORY_WHITE, new TerritoryWhitePainter());
        this.painterMap_.put(SgfId.TERRITORY_BLACK, new TerritoryBlackPainter());
        this.painterMap_.put(SgfId.DIM_POINTS, new DimPointsPainter());
        this.scope_ = this.painterMap_.keySet().toArray(new SgfId[this.painterMap_.size()]);
        this.lastDd_ = new HashSet<SgfPoint>();
    }

    @Override
    public SgfId[] markerScope() {
        SgfId[] ret = new SgfId[this.scope_.length];
        System.arraycopy(this.scope_, 0, ret, 0, ret.length);
        return ret;
    }

    @Override
    public void paintMark(GC gc, Rectangle blockArea, SgfId sgfType, boolean isTransient) {
        Painter painter = (Painter)this.painterMap_.get(sgfType);
        if (painter != null) {
            painter.paint(gc, blockArea, isTransient);
        }
    }

    @Override
    public void paintLine(GC gc, Rectangle start, Rectangle end, SgfId sgfType, boolean isTransient) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)start, (Object)end, (Object)sgfType);
        if (!SgfId.LINE.equals(sgfType) && !SgfId.ARROW.equals(sgfType)) {
            return;
        }
        Point s = Geometry.centerPoint(start);
        Point e = Geometry.centerPoint(end);
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            gc.setForeground(isTransient ? COLOR_LINE_NOGDI_TRANSIENT.get() : COLOR_LINE_NOGDI.get());
        } else {
            gc.setAntialias(1);
            gc.setAlpha(isTransient ? 48 : 255);
            gc.setForeground(COLOR_LINE.get());
        }
        gc.setLineWidth(3);
        gc.drawLine(s.x, s.y, e.x, e.y);
        if (sgfType.equals(SgfId.ARROW)) {
            double theta = s.x == e.x ? (double)Math.signum(e.y - s.y) * Math.PI / 2.0 : Math.atan2(e.y - s.y, e.x - s.x);
            double tar1 = theta + 2.356194490192345;
            double tar2 = theta - 2.356194490192345;
            double arSize = (double)start.width / 4.0;
            Point ar1 = new Point((int)((double)e.x + Math.cos(tar1) * arSize), (int)((double)e.y + Math.sin(tar1) * arSize));
            Point ar2 = new Point((int)((double)e.x + Math.cos(tar2) * arSize), (int)((double)e.y + Math.sin(tar2) * arSize));
            gc.drawLine(e.x, e.y, ar1.x, ar1.y);
            gc.drawLine(e.x, e.y, ar2.x, ar2.y);
        }
    }

    @Override
    public void paintLabel(GC gc, Rectangle block, Label label, boolean isTransient) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)block, (Object)label);
        gc.setFont(FONT_LABEL.get((int)((double)block.height / 1.41)));
        Point point = gc.textExtent(label.getLabel().getText());
        int x = block.x + block.width / 2 - point.x / 2;
        int y = block.y + block.height / 2 - point.y / 2;
        gc.setForeground(Display.getCurrent().getSystemColor(isTransient ? 13 : 9));
        gc.drawText(label.getLabel().getText(), x, y, true);
    }

    @Override
    public void paintVariation(GC gc, Rectangle blockArea, String[] labels) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)blockArea, (Object)labels);
        int cols = labels.length <= 1 ? 1 : (labels.length <= 4 ? 2 : (labels.length <= 9 ? 3 : 4));
        Point size = Geometry.divide(Geometry.getSize(blockArea), cols);
        int center = blockArea.width / (cols * 2);
        int i = 0;
        while (i < Math.min(labels.length, 16)) {
            String label = labels[i];
            gc.setFont(cols == 1 ? FONT_VARIATION.getInCircle(gc, label, size.x) : FONT_VARIATION.getInRect(gc, label, size));
            Point p = gc.textExtent(label);
            gc.setForeground(COLOR_VARIATION_FONT.get());
            gc.drawText(label, blockArea.x + center + size.x * (i % cols) - p.x / 2, blockArea.y + center + size.y * (i / cols) - p.y / 2, true);
            ++i;
        }
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView now) {
        ArgumentChecker.throwIfNull((Object)now);
        HashSet<SgfPoint> ret = new HashSet<SgfPoint>();
        ret.addAll(this.lastDd_);
        TreeSet<SgfPoint> nowDd = new TreeSet<SgfPoint>();
        InheritableMarker inheritableMarker = now.getInheritableDecoration();
        this.appendInheritable(nowDd, inheritableMarker, SgfId.DIM_POINTS, now.getSize());
        ret.addAll(nowDd);
        this.lastDd_.retainAll(nowDd);
        ret.removeAll(this.lastDd_);
        this.lastDd_.addAll(nowDd);
        return ret;
    }

    private void appendInheritable(Set<SgfPoint> set, InheritableMarker inheritableMarker, SgfId sgfType, SgfSize sgfSize) {
        String[] values = inheritableMarker.get(sgfType);
        if (values != null) {
            SgfPoint[] points;
            SgfPoint[] sgfPointArray = points = SgfPoint.parse(sgfSize, values);
            int n = 0;
            int n2 = sgfPointArray.length;
            while (n < n2) {
                SgfPoint point = sgfPointArray[n];
                set.add(point);
                ++n;
            }
        }
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        TreeSet<SgfPoint> ret = new TreeSet<SgfPoint>();
        this.calcLbLnArea(nodeView, ret);
        Object[] objectArray = this.scope_;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Property property;
            SgfId sgfType = objectArray[n];
            if (!sgfType.propertyType().equals(PropertyType.INHERIT) && (property = nodeView.getProperty(sgfType)) != null) {
                SgfPoint[] points;
                SgfPoint[] sgfPointArray = points = SgfPoint.parse(nodeView.getSize(), property.value().getStrings());
                int n3 = 0;
                int n4 = sgfPointArray.length;
                while (n3 < n4) {
                    SgfPoint point = sgfPointArray[n3];
                    ret.add(point);
                    ++n3;
                }
            }
            ++n;
        }
        objectArray = nodeView.getVariations();
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object variation = objectArray[n];
            SgfPoint point = ((NodeView)variation).getMove().getPoint();
            if (point != null && !SgfPointType.PASS.equals((Object)point.condition())) {
                ret.add(point);
            }
            ++n;
        }
        return ret;
    }

    private void calcLbLnArea(NodeView nodeView, Set<SgfPoint> redrawArea) {
        TypedString line;
        OverblockMarker overblockMarker = nodeView.getOverblockMarker();
        if (overblockMarker.isEmpty()) {
            return;
        }
        SgfSize size = nodeView.getSize();
        TypedString[] typedStringArray = overblockMarker.getLabels(size);
        int n = 0;
        int n2 = typedStringArray.length;
        while (n < n2) {
            Label label = typedStringArray[n];
            int x = 1;
            while (x <= size.width()) {
                redrawArea.add(SgfPoint.create(size, x, label.getPoint().y()));
                ++x;
            }
            ++n;
        }
        typedStringArray = overblockMarker.getLine(SgfId.LINE, size);
        n = 0;
        n2 = typedStringArray.length;
        while (n < n2) {
            line = typedStringArray[n];
            this.addLineArea((SgfLine)line, size, redrawArea);
            ++n;
        }
        typedStringArray = overblockMarker.getLine(SgfId.ARROW, size);
        n = 0;
        n2 = typedStringArray.length;
        while (n < n2) {
            line = typedStringArray[n];
            this.addLineArea((SgfLine)line, size, redrawArea);
            ++n;
        }
    }

    private void addLineArea(SgfLine line, SgfSize size, Set<SgfPoint> redrawArea) {
        int sx = Math.min(line.getStart().x(), line.getEnd().x());
        int ex = Math.max(line.getStart().x(), line.getEnd().x());
        int sy = Math.min(line.getStart().y(), line.getEnd().y());
        int ey = Math.max(line.getStart().y(), line.getEnd().y());
        int x = sx;
        while (x <= ex) {
            int y = sy;
            while (y <= ey) {
                redrawArea.add(SgfPoint.create(size, x, y));
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void paintStatus(GC gc, BlockStatus blockStatus) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)blockStatus);
        if (!blockStatus.getPointTypes().contains((Object)SgfPointType.OVERLAP)) {
            return;
        }
        Rectangle block = blockStatus.getRectangle();
        gc.setFont(FONT_LABEL.get(block.height / 2));
        Point point = gc.textExtent("!");
        int x = block.x + block.width * 3 / 4 - point.x / 2;
        int y = block.y + block.height * 1 / 4 - point.y / 2;
        gc.setForeground(Display.getCurrent().getSystemColor(8));
        gc.drawText("!", x, y, true);
    }
}

