/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.EnumSet;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.MoveInProblemCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class SolveEventDelegator
implements EventDelegator {
    public void resetStatus() {
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        if (!this.isValidMovePoint(blockStatus, nodeView)) {
            return ret;
        }
        ret.setCursor(CanvasCursor.MOVE.get(nodeView.getNextMoveColor()));
        ret.setTransientProperty(nodeView.getNextMoveColor().moveType().makeProperty(blockStatus.getPoint()));
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (!this.isValidMovePoint(blockStatus, nodeView)) {
            return false;
        }
        SgfPoint movePoint = blockStatus.getPoint();
        eventBroker.executeCommand(new MoveInProblemCommand(movePoint));
        return true;
    }

    private boolean isValidMovePoint(BlockStatus blockStatus, NodeView nodeView) {
        EnumSet<SgfPointType> set = blockStatus.getPointTypes();
        return set.contains((Object)SgfPointType.EMPTY) && !set.contains((Object)SgfPointType.FORBIDDEN) && blockStatus.getPoint() != null && nodeView.getNextMoveColor() != null;
    }

    public void updateKey(int keyCode) {
    }
}

