/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SetStone;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class SetupEventDelegator
implements EventDelegator {
    private int currentTypeIndex_ = 0;

    public void resetStatus() {
        this.currentTypeIndex_ = 0;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            return ret;
        }
        switch (this.currentTypeIndex_) {
            case 0: {
                if (blockStatus.getPointTypes().contains((Object)SgfPointType.BLACK)) break;
                ret.setCursor(CanvasCursor.SET_BLACK.getCursor());
                ret.setTransientProperty(SgfId.ADD_BLACK.makeProperty(blockStatus.getPoint()));
                break;
            }
            case 1: {
                if (blockStatus.getPointTypes().contains((Object)SgfPointType.WHITE)) break;
                ret.setCursor(CanvasCursor.SET_WHITE.getCursor());
                ret.setTransientProperty(SgfId.ADD_WHITE.makeProperty(blockStatus.getPoint()));
                break;
            }
            case 2: {
                if (blockStatus.getPointTypes().contains((Object)SgfPointType.BLACK)) {
                    ret.setCursor(CanvasCursor.SET_BLACK_ERASE.getCursor());
                    ret.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
                    break;
                }
                if (!blockStatus.getPointTypes().contains((Object)SgfPointType.WHITE)) break;
                ret.setCursor(CanvasCursor.SET_WHITE_ERASE.getCursor());
                ret.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (mouseEvent.button != 1) {
            return false;
        }
        SgfColor color = null;
        switch (this.currentTypeIndex_) {
            case 0: {
                if (blockStatus.getPointTypes().contains((Object)SgfPointType.BLACK)) {
                    return false;
                }
                color = SgfColor.BLACK;
                break;
            }
            case 1: {
                if (blockStatus.getPointTypes().contains((Object)SgfPointType.WHITE)) {
                    return false;
                }
                color = SgfColor.WHITE;
                break;
            }
            case 2: {
                if (!blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) break;
                return false;
            }
            default: {
                assert (false);
                break;
            }
        }
        SetStone command = new SetStone(blockStatus.getPoint(), color);
        eventBroker.executeCommand(command);
        return true;
    }

    public void updateKey(int keyCode) {
        switch (keyCode) {
            case 131072: {
                --this.currentTypeIndex_;
                if (this.currentTypeIndex_ >= 0) break;
                this.currentTypeIndex_ = 2;
                break;
            }
            case 262144: {
                ++this.currentTypeIndex_;
                this.currentTypeIndex_ %= 3;
            }
        }
    }
}

