/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.AnswerEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.SolveEndEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SolveEventDelegator;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemViewStateHandler
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(ProblemViewStateHandler.class);
    private final Adapter adapter_;
    static /* synthetic */ Class class$0;

    public ProblemViewStateHandler(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        this.registerDelegator(HandlerPhase.SOLVE, new SolveEventDelegator());
        this.registerDelegator(HandlerPhase.SOLVE_END, new SolveEndEventDelegator());
        this.registerDelegator(HandlerPhase.ANSWER, new AnswerEventDelegator());
        this.setEventDelegator(HandlerPhase.SOLVE);
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public HandlerPhase[] getHandlerPhases() {
        return new HandlerPhase[]{HandlerPhase.SOLVE};
    }

    private class Adapter
    implements ControllerStatusMonitor,
    ProblemStatusMonitor {
        Adapter() {
        }

        public void setEditMode(boolean isEditMode) {
        }

        public void changeHandlerPhase(HandlerPhase phase) {
            ArgumentChecker.throwIfNull((Object)phase);
            if (ProblemViewStateHandler.this.findDelegator(phase) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SOLVE + " insted. status=" + phase);
                phase = HandlerPhase.SOLVE;
            }
            ProblemViewStateHandler.this.setEventDelegator(phase);
            ProblemViewStateHandler.this.updateBlockSituation(ProblemViewStateHandler.this.getMouseEvent());
        }

        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            if (ProblemStatus.SOLVE.equals(problemStatus)) {
                ProblemViewStateHandler.this.setEventDelegator(HandlerPhase.SOLVE);
            } else if (ProblemStatus.CORRECT.equals(problemStatus) || ProblemStatus.QUASI_CORRECT.equals(problemStatus) || ProblemStatus.WRONG.equals(problemStatus)) {
                ProblemViewStateHandler.this.setEventDelegator(HandlerPhase.SOLVE_END);
            } else if (ProblemStatus.ANSWER.equals(problemStatus)) {
                ProblemViewStateHandler.this.setEventDelegator(HandlerPhase.ANSWER);
            } else {
                log_s_.debug("Unknown status:" + problemStatus);
            }
        }
    }
}

