/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.CursorResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SimpleText;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class MarkupEventDelegator
implements EventDelegator {
    private static final Messages msg_s_ = Messages.createByPackage(MarkupEventDelegator.class);
    private static final String NT_REQUEST_LABEL_TEXT = Messages.createKey(MarkupEventDelegator.class, "ntRequestLabelText");
    private static final String MSG_REQUEST_LABEL_TEXT = Messages.createKey(MarkupEventDelegator.class, "msgRequestLabelText");
    private static final CursorResource[] decorationCursors_s_;
    private static final SgfId[] markTypes_s_;
    private int currentMarkIndex_ = 0;
    static /* synthetic */ Class class$0;

    static {
        ArrayList<CursorResource> list = new ArrayList<CursorResource>(9);
        list.add(CanvasCursor.MARK_CROSS);
        list.add(CanvasCursor.MARK_CIRCLE);
        list.add(CanvasCursor.MARK_SQUARE);
        list.add(CanvasCursor.MARK_TRIANGLE);
        list.add(CanvasCursor.MARK_SELECT);
        list.add(CanvasCursor.MARK_LABEL);
        list.add(CanvasCursor.MARK_TERRITORY_WHITE);
        list.add(CanvasCursor.MARK_TERRITORY_BLACK);
        list.add(CanvasCursor.MARK_DIMMED);
        decorationCursors_s_ = list.toArray(new CursorResource[list.size()]);
        ArrayList<SgfId> list2 = new ArrayList<SgfId>(9);
        list2.add(SgfId.MARK_WITH_X);
        list2.add(SgfId.CIRCLE);
        list2.add(SgfId.SQUARE);
        list2.add(SgfId.TRIANGLE);
        list2.add(SgfId.SELECTED);
        list2.add(SgfId.LABEL);
        list2.add(SgfId.TERRITORY_WHITE);
        list2.add(SgfId.TERRITORY_BLACK);
        list2.add(SgfId.DIM_POINTS);
        markTypes_s_ = list2.toArray(new SgfId[list.size()]);
    }

    public void resetStatus() {
        this.currentMarkIndex_ = 0;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        String label;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            if (markTypes_s_[this.currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
                ret.setCursor(CanvasCursor.MARK_DIMMED_ERASE.getCursor());
                ret.setTransientProperty(SgfId.DIM_POINTS.makeProperty(SgfPoint.createPass(nodeView.getSize())));
            }
            return ret;
        }
        ret.setCursor(decorationCursors_s_[this.currentMarkIndex_].getCursor());
        if (markTypes_s_[this.currentMarkIndex_].valueType().equals((Object)ValueType.POINT)) {
            ret.setTransientProperty(markTypes_s_[this.currentMarkIndex_].makeProperty(blockStatus.getPoint()));
        } else if (markTypes_s_[this.currentMarkIndex_].equals(SgfId.LABEL) && (label = this.getLabel(nodeView, blockStatus.getPoint())).length() != 0) {
            ret.setTransientProperty(SgfId.LABEL.makeProperty(new Label(blockStatus.getPoint(), new SimpleText(label))));
        }
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            if (markTypes_s_[this.currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
                Property property = SgfId.DIM_POINTS.makeProperty(SgfPoint.createPass(nodeView.getSize()));
                eventBroker.executeCommand(new UpdateProperty(new Property[0], property, null));
                return true;
            }
            return false;
        }
        SgfPoint point = blockStatus.getPoint();
        if (mouseEvent.button == 1) {
            Property property;
            SgfId sgfType = markTypes_s_[this.currentMarkIndex_];
            boolean removeOnly = false;
            if (!SgfId.LABEL.equals(sgfType)) {
                property = new Property(sgfType, point.getString());
            } else {
                String label = this.askLabelText(nodeView, point);
                if (label == null) {
                    return false;
                }
                if (label.equals("")) {
                    property = null;
                    removeOnly = true;
                } else {
                    Label lb = new Label(point, new SimpleText(label));
                    property = new Property(sgfType, lb.getString());
                }
            }
            Property[] removeProperties = this.composeRemoveMark(nodeView, point, !removeOnly);
            eventBroker.executeCommand(new UpdateProperty(removeProperties, property, null));
            return true;
        }
        if (mouseEvent.button == 3) {
            Property[] removeProperties = this.composeRemoveMark(nodeView, point, false);
            eventBroker.executeCommand(new UpdateProperty(removeProperties, null, null));
            return true;
        }
        return false;
    }

    private String askLabelText(NodeView nodeView, SgfPoint point) {
        String lastLabel = this.getLabel(nodeView, point);
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), msg_s_.get(NT_REQUEST_LABEL_TEXT), msg_s_.get(MSG_REQUEST_LABEL_TEXT), lastLabel, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private String getLabel(NodeView nodeView, SgfPoint point) {
        Property property = nodeView.getProperty(SgfId.LABEL);
        if (property == null) {
            return "";
        }
        String[] data = property.value().getStrings();
        int i = 0;
        while (i < data.length) {
            Label label = Label.parseQuietly(point.size(), data[i]);
            if (label != null && label.getPoint().equals(point)) {
                return label.getLabel().getText();
            }
            ++i;
        }
        return "";
    }

    private Property[] composeRemoveMark(NodeView nodeView, SgfPoint point, boolean ignoreCurrentMark) {
        ArrayList<Property> ret = new ArrayList<Property>(markTypes_s_.length);
        int i = 0;
        while (i < markTypes_s_.length) {
            if (!ignoreCurrentMark || i != this.currentMarkIndex_) {
                if (SgfId.LABEL.equals(markTypes_s_[i])) {
                    Label lb = new Label(point, new SimpleText(this.getLabel(nodeView, point)));
                    ret.add(markTypes_s_[i].makeProperty(lb));
                } else {
                    ret.add(markTypes_s_[i].makeProperty(point));
                }
            }
            ++i;
        }
        return ret.toArray(new Property[ret.size()]);
    }

    public void updateKey(int keyCode) {
        switch (keyCode) {
            case 131072: {
                --this.currentMarkIndex_;
                if (this.currentMarkIndex_ >= 0) break;
                this.currentMarkIndex_ = decorationCursors_s_.length - 1;
                break;
            }
            case 262144: {
                ++this.currentMarkIndex_;
                this.currentMarkIndex_ %= decorationCursors_s_.length;
            }
        }
    }
}

