/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.unitarou.jface.CursorResource;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.swt.Line;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class LineEventDelegator
implements EventDelegator {
    private static final State FREE = new State("free");
    private static final State BOUND = new State("bound");
    private static final CursorResource[] decorationCursors_s_;
    private static final SgfId[] markIds_s_;
    private int currentLineIndex_ = 0;
    private State state_ = FREE;
    private SgfPoint startPoint_;

    static {
        ArrayList<CursorResource> list = new ArrayList<CursorResource>(2);
        list.add(CanvasCursor.MARK_LINE);
        list.add(CanvasCursor.MARK_ARROW);
        decorationCursors_s_ = list.toArray(new CursorResource[list.size()]);
        ArrayList<SgfId> list2 = new ArrayList<SgfId>(2);
        list2.add(SgfId.LINE);
        list2.add(SgfId.ARROW);
        markIds_s_ = list2.toArray(new SgfId[list.size()]);
    }

    public void resetStatus() {
        this.currentLineIndex_ = 0;
        this.state_ = FREE;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent);
        BlockSituation ret = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            return ret;
        }
        ret.setCursor(decorationCursors_s_[this.currentLineIndex_].getCursor());
        if (BOUND.equals(this.state_)) {
            SgfLine line = new SgfLine(this.startPoint_, blockStatus.getPoint());
            ret.setTransientProperty(markIds_s_[this.currentLineIndex_].makeProperty(line));
        } else {
            Property touchedLine = this.findTouchedLine(nodeView, blockStatus, mouseEvent);
            if (touchedLine != null) {
                ret.setTransientProperty(touchedLine);
            }
        }
        return ret;
    }

    private Property findTouchedLine(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        TreeMap<Double, Property> map = new TreeMap<Double, Property>();
        SgfId[] sgfIdArray = markIds_s_;
        int n = 0;
        int n2 = sgfIdArray.length;
        while (n < n2) {
            SgfId id = sgfIdArray[n];
            Property property = nodeView.getProperty(id);
            if (property != null) {
                String[] stringArray = property.value().getStrings();
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String string = stringArray[n3];
                    SgfLine sgfLine = SgfLine.parseQuietly(nodeView.getSize(), string);
                    if (sgfLine != null) {
                        Point blockCenter = Geometry.centerPoint(blockStatus.getRectangle());
                        int size = blockStatus.getRectangle().width;
                        Point start = new Point(blockCenter.x - (blockStatus.getPoint().x() - sgfLine.getStart().x()) * size, blockCenter.y - (blockStatus.getPoint().y() - sgfLine.getStart().y()) * size);
                        Point end = new Point(blockCenter.x - (blockStatus.getPoint().x() - sgfLine.getEnd().x()) * size, blockCenter.y - (blockStatus.getPoint().y() - sgfLine.getEnd().y()) * size);
                        double distance = new Line(start, end).distance(new Point(mouseEvent.x, mouseEvent.y));
                        map.put(new Double(distance), new Property(id, string));
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (map.isEmpty()) {
            return null;
        }
        if ((Double)map.firstKey() < 6.0) {
            Property property = (Property)map.get(map.firstKey());
            return property;
        }
        return null;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (FREE.equals(this.state_)) {
            return this.executeEventInFree(nodeView, blockStatus, mouseEvent, eventBroker);
        }
        if (BOUND.equals(this.state_)) {
            return this.executeEventInBound(nodeView, blockStatus, mouseEvent, eventBroker);
        }
        assert (false) : "Unknown state: " + this.state_;
        return false;
    }

    private boolean executeEventInFree(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        Property property;
        if (mouseEvent.button == 1) {
            this.startPoint_ = blockStatus.getPoint();
            this.state_ = BOUND;
            return false;
        }
        if (mouseEvent.button == 3 && (property = this.findTouchedLine(nodeView, blockStatus, mouseEvent)) != null) {
            eventBroker.executeCommand(new UpdateProperty(new Property[]{property}, null, null));
            return true;
        }
        return false;
    }

    private boolean executeEventInBound(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        if (mouseEvent.button == 1) {
            SgfLine line = new SgfLine(this.startPoint_, blockStatus.getPoint());
            Property property = new Property(markIds_s_[this.currentLineIndex_], line.getString());
            eventBroker.executeCommand(new UpdateProperty(new Property[0], property, null));
            this.state_ = FREE;
            this.startPoint_ = null;
            return true;
        }
        if (mouseEvent.button == 3) {
            this.state_ = FREE;
            this.startPoint_ = null;
            return true;
        }
        return false;
    }

    public void updateKey(int keyCode) {
        switch (keyCode) {
            case 131072: {
                --this.currentLineIndex_;
                if (this.currentLineIndex_ >= 0) break;
                this.currentLineIndex_ = decorationCursors_s_.length - 1;
                break;
            }
            case 262144: {
                ++this.currentLineIndex_;
                this.currentLineIndex_ %= decorationCursors_s_.length;
            }
        }
    }

    private static class State
    extends UEnum {
        protected State(String typeName) {
            super((Comparable)((Object)typeName));
        }
    }
}

