/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRuledLinePainter
implements RuledLinePainter {
    private static final ColorResource COLOR_RULEDLINE = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_STAR = new ColorResource(0, 0, 0);
    private static final double RADIUS_STAR = 0.1;
    private static final int SIZE_THRESHOLD_RULEDLINE = 5;
    private static final int SIZE_THRESHOLD_SINGLE_LINE = 10;
    private static final double[] LEFT_POS = new double[]{0.5, 0.5, 0.0, 0.5};
    private static final double[] RIGHT_POS = new double[]{1.0, 0.5, 0.5, 0.5};
    private static final double[] UP_POS = new double[]{0.5, 0.0, 0.5, 0.5};
    private static final double[] DOWN_POS = new double[]{0.5, 0.5, 0.5, 1.0};
    private static final double[] LEFT_OUTER = new double[]{0.0, 0.0, 0.0, 1.0};
    private static final double[] RIGHT_OUTER = new double[]{1.0, 0.0, 1.0, 1.0};
    private static final double[] UP_OUTER = new double[]{0.0, 0.0, 1.0, 0.0};
    private static final double[] DOWN_OUTER = new double[]{0.0, 1.0, 1.0, 1.0};
    private static final SortedMap<SgfPointType, double[][]> pt2PossitionMap_s_ = new TreeMap<SgfPointType, double[][]>();
    private static final SortedMap<SgfPointType, int[]> pt2LineWidthMap_s_ = new TreeMap<SgfPointType, int[]>();
    private boolean isFirst_ = true;

    static {
        pt2PossitionMap_s_.put(SgfPointType.TOP_LEFT, new double[][]{RIGHT_POS, DOWN_POS, LEFT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.TOP, new double[][]{LEFT_POS, RIGHT_POS, DOWN_POS, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.TOP_RIGHT, new double[][]{LEFT_POS, DOWN_POS, RIGHT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_RIGHT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.LEFT, new double[][]{UP_POS, DOWN_POS, RIGHT_POS, LEFT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.EMPTY, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_POS});
        pt2LineWidthMap_s_.put(SgfPointType.EMPTY, new int[]{1, 1, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.RIGHT, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.RIGHT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_LEFT, new double[][]{RIGHT_POS, UP_POS, LEFT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM, new double[][]{LEFT_POS, RIGHT_POS, UP_POS, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_RIGHT, new double[][]{LEFT_POS, UP_POS, RIGHT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_RIGHT, new int[]{2, 2, 1, 1});
    }

    @Override
    public void paint(GC gc, SgfPoint point, Rectangle rectangle) {
        this.drawRuledLine(gc, point, rectangle);
        this.drawStar(gc, point, rectangle);
    }

    private void drawRuledLine(GC gc, SgfPoint point, Rectangle rectangle) {
        int size = Math.min(rectangle.width, rectangle.height);
        if (size < 5) {
            return;
        }
        SgfPointType pointType = SgfPointType.classify(point);
        int[][] linePos = this.createLinePossition(pointType, rectangle);
        int[] lineWidth = (int[])pt2LineWidthMap_s_.get((Object)pointType);
        gc.setLineStyle(1);
        gc.setForeground(COLOR_RULEDLINE.get());
        int i = 0;
        while (i < linePos.length) {
            gc.setLineWidth(size < 10 ? 1 : lineWidth[i]);
            gc.drawLine(linePos[i][0], linePos[i][1], linePos[i][2], linePos[i][3]);
            ++i;
        }
    }

    private int[][] createLinePossition(SgfPointType pointType, Rectangle rectangle) {
        double[][] relPos = (double[][])pt2PossitionMap_s_.get((Object)pointType);
        int[][] ret = new int[relPos.length][];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new int[relPos[i].length];
            int j = 0;
            while (j < ret[i].length) {
                ret[i][j] = (int)(relPos[i][j] * (double)rectangle.width + (double)rectangle.x);
                ret[i][j + 1] = (int)(relPos[i][j + 1] * (double)rectangle.height + (double)rectangle.y);
                j += 2;
            }
            ++i;
        }
        return ret;
    }

    private void drawStar(GC gc, SgfPoint point, Rectangle rectangle) {
        if (!point.size().isStarPoint(point)) {
            return;
        }
        int radius = (int)((double)rectangle.width * 0.1);
        if (radius < 1) {
            return;
        }
        gc.setForeground(COLOR_STAR.get());
        gc.setBackground(COLOR_STAR.get());
        gc.fillOval(rectangle.x + rectangle.width / 2 - radius, rectangle.y + rectangle.height / 2 - radius, radius * 2 + 1, radius * 2 + 1);
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView now) {
        if (this.isFirst_) {
            this.isFirst_ = false;
            return now.getSize().all();
        }
        return BlockPainter.EMPTY_SET;
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        return BlockPainter.EMPTY_SET;
    }
}

