/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.lang.Classes;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.board.CoordinatesPainter;

public class SimpleCoordinatesPainter
implements CoordinatesPainter {
    private static final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();
    private static final ColorResource FONT_COLOR = new ColorResource(0, 0, 0);
    private final String FKEY_LABEL = Classes.uniqueKey(this, "FKEY_LABEL");
    private Point labelSize_ = null;
    private CoordinatesLabelProvider provider_ = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, null);
    static /* synthetic */ Class class$0;

    public void setLabelProvider(CoordinatesLabelProvider provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        this.provider_ = provider;
        this.labelSize_ = null;
    }

    public void paint(GC gc, Rectangle rectangle, SgfRectangle sgfRectangle, boolean[] visibles) {
        Point size;
        String label;
        int BLOCK_X = rectangle.width / sgfRectangle.width();
        int BLOCK_Y = rectangle.height / sgfRectangle.height();
        SgfSize sgfSize = sgfRectangle.getStart().size();
        gc.setForeground(FONT_COLOR.get());
        if (visibles[0]) {
            int y = sgfRectangle.getStart().y();
            while (y <= sgfRectangle.getEnd().y()) {
                label = this.getYaxisLabel(sgfSize, y);
                size = gc.stringExtent(label);
                size.x = rectangle.x - size.x;
                size.y = BLOCK_Y * (y - sgfRectangle.getStart().y()) + (BLOCK_Y - size.y) / 2 + rectangle.y;
                gc.drawString(label, size.x, size.y, true);
                ++y;
            }
        }
        if (visibles[1]) {
            int x = sgfRectangle.getStart().x();
            while (x <= sgfRectangle.getEnd().x()) {
                label = this.getXaxisLabel(sgfSize, x);
                size = gc.stringExtent(label);
                size.x = BLOCK_X * (x - sgfRectangle.getStart().x()) + (BLOCK_X - size.x) / 2 + rectangle.x;
                size.y = rectangle.y - size.y;
                gc.drawString(label, size.x, size.y, true);
                ++x;
            }
        }
    }

    public Point calcLabelSize(SgfRectangle sgfRectangle) {
        ArgumentChecker.throwIfNull((Object)sgfRectangle);
        if (this.labelSize_ != null) {
            return new Point(this.labelSize_.x, this.labelSize_.y);
        }
        if (fontRegistry_s_.get(this.FKEY_LABEL) == null) {
            fontRegistry_s_.put(this.FKEY_LABEL, Display.getCurrent().getSystemFont().getFontData());
        }
        GC gc = new GC(Display.getCurrent());
        try {
            Point point;
            String label;
            SgfSize size = sgfRectangle.getStart().size();
            this.labelSize_ = new Point(0, 0);
            gc.setFont(fontRegistry_s_.get(this.FKEY_LABEL));
            int x = sgfRectangle.getStart().x();
            while (x <= sgfRectangle.getEnd().x()) {
                label = this.getXaxisLabel(size, x);
                if (label.length() != 0) {
                    point = gc.stringExtent(label);
                    this.labelSize_.x = Math.max(this.labelSize_.x, point.x);
                    this.labelSize_.y = Math.max(this.labelSize_.y, point.y);
                }
                ++x;
            }
            int y = sgfRectangle.getStart().y();
            while (y <= sgfRectangle.getEnd().y()) {
                label = this.getYaxisLabel(size, y);
                if (label.length() != 0) {
                    point = gc.stringExtent(label);
                    this.labelSize_.x = Math.max(this.labelSize_.x, point.x);
                    this.labelSize_.y = Math.max(this.labelSize_.y, point.y);
                }
                ++y;
            }
            Point point2 = new Point(this.labelSize_.x, this.labelSize_.y);
            return point2;
        }
        finally {
            gc.dispose();
        }
    }

    private String getXaxisLabel(SgfSize size, int x) {
        return this.provider_.getXLabel(SgfPoint.create(size, x, 1));
    }

    private String getYaxisLabel(SgfSize size, int y) {
        return this.provider_.getYLabel(SgfPoint.create(size, 1, y));
    }

    public void setFontData(FontData fontData) {
        ArgumentChecker.throwIfNull((Object)fontData);
        fontRegistry_s_.put(this.FKEY_LABEL, new FontData[]{fontData});
        this.labelSize_ = null;
    }
}

