/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Map;
import java.util.SortedMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.TextViewer;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;

public class IgoTextBoardPanel
implements IgoBoardPanel {
    private final IgoBoard igoBoard_ = new IgoBoard(SgfSize.DEFAULT);
    private final Composite parent_;
    private final Label control_;

    public IgoTextBoardPanel(Composite parent) {
        this.parent_ = parent;
        this.control_ = new Label(this.parent_, 2052);
        FontData fd = new FontData("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 20, 0);
        Font font = new Font((Device)this.parent_.getDisplay(), fd);
        this.control_.setFont(font);
        this.draw();
    }

    private int boardLength() {
        return this.igoBoard_.size().height() * (this.igoBoard_.size().width() + 1);
    }

    public void update(NodeView nodeView) {
        if (nodeView == null) {
            throw new NullArgumentException();
        }
        IgoBoardView newPosition = nodeView.getIgoBoard();
        if (!this.igoBoard_.size().equals(newPosition.size())) {
            this.igoBoard_.setSize(newPosition.size());
        }
        this.updateModel(newPosition);
        this.draw();
    }

    private void updateModel(IgoBoardView newPosition) {
        SortedMap<SgfPoint, SgfColor> diff = newPosition.diff(this.igoBoard_);
        for (Map.Entry<SgfPoint, SgfColor> entry : diff.entrySet()) {
            SgfPoint point = entry.getKey();
            SgfColor color = entry.getValue();
            this.igoBoard_.removeStone(point);
            if (color == null) continue;
            this.igoBoard_.setStone(new Stone(color, point, null));
        }
        this.igoBoard_.setCaptured(newPosition.getCaptured());
    }

    private void draw() {
        StringBuilder text = new StringBuilder(this.boardLength());
        TextViewer viewer = new TextViewer();
        String[] boardLine = viewer.write(this.igoBoard_);
        int i = 0;
        while (i < boardLine.length) {
            text.append(boardLine[i]);
            text.append(Strings.LINE_SEPARATOR);
            ++i;
        }
        text.append(viewer.getCharacter(SgfPointType.BLACK));
        text.append(this.igoBoard_.getCaptured(SgfColor.BLACK).size());
        text.append(" ");
        text.append(viewer.getCharacter(SgfPointType.WHITE));
        text.append(this.igoBoard_.getCaptured(SgfColor.WHITE).size());
        this.control_.setText(text.toString());
    }

    public void setEditMode(boolean isEditMode) {
    }

    public Control createContents(Composite parent) {
        return null;
    }

    public void dispose() {
    }

    public Canvas getCanvas() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public BlockStatus getBlockStatus(Point canvasPoint) {
        return null;
    }

    public NodeView getNodeView() {
        return null;
    }

    public void paintInTransient(Property property) {
    }

    public void setContext(CurrentContext context) {
    }
}

