/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsPanel<T extends IgoOutlinePanel>
implements WidgetContainer {
    private final IgoOutlinePanelFactory<T> factory_;
    private ScrolledComposite scrolledComposite_;
    private Composite frame_;
    private GridLayout gridLayout_;
    private List<T> list_;

    public CollectionsPanel(IgoOutlinePanelFactory<T> factory) {
        this(factory, 4);
    }

    public CollectionsPanel(IgoOutlinePanelFactory<T> factory, int col) {
        ArgumentChecker.throwIfNull(factory);
        if (col <= 0) {
            throw new IllegalArgumentException("Bad size of column: " + col);
        }
        this.factory_ = factory;
        this.scrolledComposite_ = null;
        this.frame_ = null;
        this.gridLayout_ = new GridLayout(col, false);
        this.list_ = new ArrayList<T>();
    }

    @Override
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        Composite group = new Composite(parent, 0);
        group.setLayout(new FillLayout());
        this.scrolledComposite_ = new ScrolledComposite(group, 512);
        this.scrolledComposite_.setLayout(new FillLayout());
        this.scrolledComposite_.setExpandHorizontal(true);
        this.scrolledComposite_.setExpandVertical(false);
        this.scrolledComposite_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CollectionsPanel.this.resized();
            }
        });
        this.frame_ = new Composite(this.scrolledComposite_, 0);
        this.scrolledComposite_.setContent(this.frame_);
        return group;
    }

    private void resized() {
        int width;
        Point point = Geometry.getSize(this.scrolledComposite_.getClientArea());
        point.x = width = point.x / this.gridLayout_.numColumns - (this.gridLayout_.horizontalSpacing * 2 + this.frame_.getBorderWidth());
        point.y = width;
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.setBoardSize(point);
        }
        this.frame_.pack();
    }

    @Override
    public void dispose() {
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.dispose();
        }
    }

    public void set(Collection[] collections) {
        Collection collection;
        ArgumentChecker.throwIfNull((Object)collections);
        this.frame_.dispose();
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.dispose();
        }
        this.list_.clear();
        this.frame_ = new Composite(this.scrolledComposite_, 0);
        this.frame_.setLayout(this.gridLayout_);
        int size = 0;
        Collection[] collectionArray = collections;
        int n = 0;
        int n2 = collectionArray.length;
        while (n < n2) {
            collection = collectionArray[n];
            size += collection.size();
            ++n;
        }
        collectionArray = collections;
        n = 0;
        n2 = collectionArray.length;
        while (n < n2) {
            collection = collectionArray[n];
            int j = 0;
            while (j < collection.size()) {
                T igoOutlinePanel = this.factory_.create();
                Control control = ((IgoOutlinePanel)igoOutlinePanel).createContents(this.frame_);
                GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
                control.setLayoutData(gridData);
                ((IgoOutlinePanel)igoOutlinePanel).setRootGameTree(collection.get(j));
                this.list_.add(igoOutlinePanel);
                ++j;
            }
            ++n;
        }
        this.resized();
        this.scrolledComposite_.setContent(this.frame_);
        this.scrolledComposite_.setMinSize(this.frame_.getSize());
    }

    public T[] getPanels(T[] ts) {
        return (IgoOutlinePanel[])this.list_.toArray(ts);
    }

    protected Composite getFrame() {
        return this.frame_;
    }

    protected void setFocus(RootGameTree rootGameTree) {
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.setFocus(rootGameTree.equals(igoOutlinePanel.getRootGameTree()));
        }
    }

    protected void setFocus(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        HashSet<RootGameTree> set = new HashSet<RootGameTree>();
        int i = 0;
        while (i < collection.size()) {
            set.add(collection.get(i));
            ++i;
        }
        Point ul = this.frame_.getSize();
        Point br = new Point(0, 0);
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            boolean focused = set.contains(igoOutlinePanel.getRootGameTree());
            igoOutlinePanel.setFocus(focused);
            if (!focused) continue;
            Control control = igoOutlinePanel.getControl();
            Point pul = control.getLocation();
            Point pbr = Geometry.add(pul, control.getSize());
            ul = Geometry.min(ul, pul);
            br = Geometry.max(br, pbr);
        }
        Point sp = this.scrolledComposite_.getOrigin();
        Point size = Geometry.getSize(this.scrolledComposite_.getClientArea());
        if (ul.y < sp.y) {
            this.scrolledComposite_.setOrigin(ul);
        } else if (sp.y + size.y < br.y) {
            Point np = Geometry.subtract(br, size);
            this.scrolledComposite_.setOrigin(np);
        }
    }
}

