/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.yukinoshita.view.jface.ann.Editor;
import org.unitarou.yukinoshita.view.jface.ann.RootAnnotationPanel;

class SizeEditor
extends Editor {
    private static final MessageResource CLB_SIZE_HEIGHT = new MessageResource(RootAnnotationPanel.class, "clbSizeHeight");
    private static final MessageResource CLB_SIZE_WIDTH = new MessageResource(RootAnnotationPanel.class, "clbSizeWidth");
    private StackLayout stackLayout_;
    private Composite advancedPanel_;
    private Composite normalPanel_;
    private Combo cbSize_;
    private Combo cbHorizontalSize_;
    private Combo cbVerticalSize_;
    private boolean enableAdvanced_ = false;
    private final ComboFocusLost comboFocusLost_ = new ComboFocusLost();
    static /* synthetic */ Class class$0;

    SizeEditor() {
    }

    void setAdvanced(boolean enable4Advanced) {
        this.enableAdvanced_ = enable4Advanced;
        this.stackLayout_.topControl = this.enableAdvanced_ ? this.advancedPanel_ : this.normalPanel_;
        this.stackLayout_.topControl.getParent().layout();
    }

    public Control createContents(Composite parent) {
        Composite frame = new Composite(parent, 0);
        this.stackLayout_ = new StackLayout();
        frame.setLayout(this.stackLayout_);
        this.normalPanel_ = this.createNormalEditor(frame);
        this.advancedPanel_ = this.createAdvancedEditor(frame);
        this.stackLayout_.topControl = this.normalPanel_;
        return frame;
    }

    private Composite createNormalEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new FillLayout());
        this.cbSize_ = new Combo(composite, 12);
        int i = 1;
        while (i <= SgfSize.MAX.height()) {
            String size = String.valueOf(i);
            this.cbSize_.add(String.valueOf(size) + 'x' + size);
            ++i;
        }
        this.cbSize_.select(SgfSize.DEFAULT.height() - 1);
        this.cbSize_.addFocusListener(this.comboFocusLost_);
        this.cbSize_.setData(SgfId.SIZE);
        return composite;
    }

    private Composite createAdvancedEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout(gridLayout);
        Label label = new Label(composite, 131072);
        label.setText(CLB_SIZE_HEIGHT.get());
        label.setLayoutData(new GridData(128));
        this.cbVerticalSize_ = this.createSizeCombo(composite);
        this.cbVerticalSize_.addFocusListener(this.comboFocusLost_);
        label = new Label(composite, 131072);
        label.setText(CLB_SIZE_WIDTH.get());
        label.setLayoutData(new GridData(128));
        this.cbHorizontalSize_ = this.createSizeCombo(composite);
        this.cbHorizontalSize_.addFocusListener(this.comboFocusLost_);
        return composite;
    }

    public void dispose() {
    }

    private Combo createSizeCombo(Composite parent) {
        Combo combo = new Combo(parent, 12);
        combo.setLayoutData(new GridData(768));
        int i = 1;
        while (i <= SgfSize.MAX.height()) {
            combo.add(String.valueOf(i));
            ++i;
        }
        combo.select(SgfSize.DEFAULT.height() - 1);
        combo.setData(SgfId.SIZE);
        return combo;
    }

    void select(SgfSize sgfSize) {
        this.cbHorizontalSize_.select(sgfSize.width() - 1);
        this.cbVerticalSize_.select(sgfSize.height() - 1);
        this.cbSize_.select(sgfSize.height() - 1);
    }

    void setEditable(boolean isEditMode) {
        this.cbSize_.setEnabled(isEditMode);
        this.cbHorizontalSize_.setEnabled(isEditMode);
        this.cbVerticalSize_.setEnabled(isEditMode);
    }

    String getDatum() {
        if (this.enableAdvanced_) {
            int height = this.cbVerticalSize_.getSelectionIndex() + 1;
            int width = this.cbHorizontalSize_.getSelectionIndex() + 1;
            return SgfSize.create(width, height).getString();
        }
        int size = this.cbSize_.getSelectionIndex() + 1;
        return SgfSize.create(size, size).getString();
    }

    private class ComboFocusLost
    extends FocusAdapter {
        ComboFocusLost() {
        }

        public void focusLost(FocusEvent e) {
            SizeEditor.this.fireModifyText(e.widget);
        }
    }
}

