/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.USpinner;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.yukinoshita.view.jface.ann.Editor;

class RealEditor
extends Editor {
    private StackLayout stackLayout_;
    private USpinner spinner_;
    private Text text_;
    private final SgfId sgfId_;
    private final int min_;
    private final int max_;
    private final int digits_;
    private final int inc_;
    private final int page_;

    RealEditor(SgfId sgfId, int min, int max, int digits, int inc, int page) {
        this.sgfId_ = sgfId;
        this.min_ = min;
        this.max_ = max;
        this.digits_ = digits;
        this.inc_ = inc;
        this.page_ = page;
    }

    public Control createContents(Composite parent) {
        Composite frame = new Composite(parent, 0);
        this.stackLayout_ = new StackLayout();
        frame.setLayout(this.stackLayout_);
        this.createSpinnerEditor(frame);
        this.createTextEditor(frame);
        this.stackLayout_.topControl = this.spinner_;
        return frame;
    }

    private Control createSpinnerEditor(Composite parent) {
        this.spinner_ = new USpinner(parent, 2048);
        this.spinner_.setMinimum(this.min_);
        this.spinner_.setMaximum(this.max_);
        this.spinner_.setDigits(this.digits_);
        this.spinner_.setIncrement(this.inc_);
        this.spinner_.setPageIncrement(this.page_);
        this.spinner_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RealEditor.this.fireModifyText(RealEditor.this.spinner_, RealEditor.this);
            }
        });
        return this.spinner_;
    }

    private Control createTextEditor(Composite frame) {
        this.text_ = new Text(frame, 2052);
        this.text_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RealEditor.this.fireModifyText(RealEditor.this.text_, RealEditor.this);
            }
        });
        return this.text_;
    }

    public void dispose() {
    }

    void setProperty(Property resultProperty) {
        String oldString;
        if (resultProperty == null) {
            this.stackLayout_.topControl = this.spinner_;
            return;
        }
        String string = Sgfs.unescapeSimpleTextForRead(resultProperty.value().getString());
        String string2 = oldString = this.stackLayout_.topControl == this.text_ ? this.text_.getText() : this.spinner_.getText();
        if (string.equals(oldString)) {
            return;
        }
        try {
            double value = Double.parseDouble(string);
            this.spinner_.setSelection((int)(value * Math.pow(10.0, this.spinner_.getDigits())));
            this.stackLayout_.topControl = this.spinner_;
        }
        catch (NumberFormatException ignore) {
            this.text_.setText(string);
            this.stackLayout_.topControl = this.text_;
        }
        this.stackLayout_.topControl.getParent().layout();
    }

    void setEditable(boolean isEditMode) {
        this.spinner_.setEnabled(isEditMode);
        this.text_.setEditable(isEditMode);
    }

    SgfId getSgfId() {
        return this.sgfId_;
    }

    String getDatum() {
        String newValue;
        if (this.stackLayout_.topControl == this.text_) {
            return this.text_.getText();
        }
        if (this.spinner_.getDigits() == 0) {
            newValue = String.valueOf(this.spinner_.getSelection());
        } else {
            double value = (double)this.spinner_.getSelection() / Math.pow(10.0, this.spinner_.getDigits());
            newValue = String.valueOf(value);
        }
        return newValue;
    }
}

