/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.RealEditor;
import org.unitarou.yukinoshita.view.jface.ann.ResultEditor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameAnnotationPanel
extends AnnotationPanel
implements WidgetContainer {
    private static final SgfId[] TYPE_SIMPLE_TEXT = new SgfId[]{SgfId.GAME_NAME, SgfId.PLAYER_WHITE, SgfId.WHITE_RANK, SgfId.WHITE_TEAM, SgfId.PLAYER_BLACK, SgfId.BLACK_RANK, SgfId.BLACK_TEAM, SgfId.DATE, SgfId.EVENT, SgfId.ROUND, SgfId.PLACE, SgfId.RULES, SgfId.OVERTIME, SgfId.USER, SgfId.SOURCE, SgfId.COPYRIGHT, SgfId.ANNOTATION, SgfId.OPENING};
    private static final SgfId[] TYPE_SPINNER = new SgfId[]{SgfId.HANDICAP, SgfId.KOMI, SgfId.TIMELIMIT};
    private GameType gameType_;
    private Composite group_;
    private final Map<SgfId, Object> widgetMap_;
    private final Adapter adapter_;
    private final TextListener textListener_;
    private final SpinnerModifyListened spinnerModifyListened_;
    private final ResultModifyListened resultModifyListened_;
    private NodeView nodeView_;
    private boolean isEditMode_;

    public GameAnnotationPanel(GameType gameType) {
        this.gameType_ = gameType;
        ArgumentChecker.throwIfNull((Object)gameType);
        this.widgetMap_ = new HashMap<SgfId, Object>();
        this.adapter_ = new Adapter();
        this.textListener_ = new TextListener();
        this.spinnerModifyListened_ = new SpinnerModifyListened();
        this.resultModifyListened_ = new ResultModifyListened();
        this.isEditMode_ = false;
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        Object ret = super.getAdapter(adapter);
        if (ret != null) {
            return ret;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        this.group_ = new Composite(parent, 0);
        this.group_.setLayout(new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(this.group_, 512);
        sc.setLayout(new FillLayout());
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(false);
        Composite composite = this.gameType_.equals(GameType.PROBLEM) ? this.createProblemContents(sc) : (this.gameType_.equals(GameType.DRILL) ? this.createDrillContents(sc) : this.createGameContents(sc));
        composite.pack();
        sc.setContent(composite);
        sc.setMinSize(composite.getSize());
        this.adapter_.setEditMode(this.isEditMode_);
        return this.group_;
    }

    private Composite createGameContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite, SgfId.GAME_NAME);
        this.createTextEditor(composite, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite, SgfId.PLAYER_WHITE);
        this.createSimpleTextEditor(composite, SgfId.WHITE_RANK);
        this.createSimpleTextEditor(composite, SgfId.WHITE_TEAM);
        this.createSimpleTextEditor(composite, SgfId.PLAYER_BLACK);
        this.createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        this.createSimpleTextEditor(composite, SgfId.BLACK_TEAM);
        this.createHandicapEditor(composite);
        this.createResultEditor(composite);
        this.createSimpleTextEditor(composite, SgfId.DATE);
        this.createSimpleTextEditor(composite, SgfId.EVENT);
        this.createSimpleTextEditor(composite, SgfId.ROUND);
        this.createSimpleTextEditor(composite, SgfId.PLACE);
        this.createSimpleTextEditor(composite, SgfId.RULES);
        this.createReal(composite, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        this.createSimpleTextEditor(composite, SgfId.OVERTIME);
        this.createSimpleTextEditor(composite, SgfId.USER);
        this.createSimpleTextEditor(composite, SgfId.SOURCE);
        this.createSimpleTextEditor(composite, SgfId.COPYRIGHT);
        this.createSimpleTextEditor(composite, SgfId.ANNOTATION);
        this.createSimpleTextEditor(composite, SgfId.OPENING);
        return composite;
    }

    private Composite createProblemContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite, SgfId.GAME_NAME);
        this.createResultEditor(composite);
        this.createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        this.createReal(composite, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        this.createTextEditor(composite, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite, SgfId.DATE);
        this.createSimpleTextEditor(composite, SgfId.SOURCE);
        this.createSimpleTextEditor(composite, SgfId.USER);
        this.createSimpleTextEditor(composite, SgfId.COPYRIGHT);
        return composite;
    }

    private Composite createDrillContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite, SgfId.GAME_NAME);
        this.createSimpleTextEditor(composite, SgfId.BLACK_RANK);
        this.createTextEditor(composite, SgfId.GAME_COMMENT);
        return composite;
    }

    private Text createSimpleTextEditor(Composite parent, SgfId sgfType) {
        Label label = new Label(parent, 131072);
        label.setText(sgfType.displayName());
        GridData gridData = new GridData(3, 2, false, false);
        label.setLayoutData(gridData);
        Text text = new Text(parent, 2052);
        gridData = new GridData(4, 4, true, true);
        text.setLayoutData(gridData);
        text.addFocusListener(this.textListener_);
        text.addModifyListener(this.textListener_);
        text.setData(sgfType);
        this.widgetMap_.put(sgfType, text);
        return text;
    }

    private void createTextEditor(Composite parent, SgfId sgfType) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 5);
        composite.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 5;
        composite.setLayout(gridLayout);
        Label label = new Label(composite, 131072);
        label.setText(sgfType.displayName());
        gridData = new GridData(1, 1, false, false);
        label.setLayoutData(gridData);
        Text text = new Text(composite, 2626);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = label.computeSize((int)-1, (int)-1).y * 10;
        text.setLayoutData(gridData);
        text.addFocusListener(this.textListener_);
        text.addModifyListener(this.textListener_);
        text.setData(sgfType);
        this.widgetMap_.put(sgfType, text);
    }

    private void createReal(Composite parent, SgfId sgfId, int min, int max, int digits, int inc, int page) {
        Label label = new Label(parent, 131072);
        label.setText(sgfId.displayName());
        GridData gridData = new GridData(3, 2, false, false);
        label.setLayoutData(gridData);
        RealEditor realEditor = new RealEditor(sgfId, min, max, digits, inc, page);
        Control control = realEditor.createContents(parent);
        gridData = new GridData(4, 4, true, true);
        control.setLayoutData(gridData);
        realEditor.addModifyListener(this.spinnerModifyListened_);
        this.widgetMap_.put(sgfId, realEditor);
    }

    private void createHandicapEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout(gridLayout);
        this.createReal(composite, SgfId.HANDICAP, 0, 99, 0, 1, 5);
        this.createReal(composite, SgfId.KOMI, -999, 999, 1, 5, 10);
    }

    private void createResultEditor(Composite parent) {
        ResultEditor resultEditor = new ResultEditor();
        Control control = resultEditor.createContents(parent);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        control.setLayoutData(gridData);
        resultEditor.addModifyListener(this.resultModifyListened_);
        this.widgetMap_.put(SgfId.RESULT, resultEditor);
    }

    public Control getControl() {
        return this.group_;
    }

    @Override
    public void dispose() {
    }

    private class TextListener
    extends FocusAdapter
    implements ModifyListener {
        private final Map<Text, String> lastStringMap_ = new HashMap<Text, String>();

        TextListener() {
        }

        public void modifyText(ModifyEvent e) {
            String newText;
            int charLength;
            Text text = (Text)e.widget;
            String lastText = this.lastStringMap_.get(text);
            if (lastText == null) {
                lastText = "";
            }
            if ((charLength = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE)) <= Strings.calcDiffSize(lastText, newText = text.getText())) {
                this.update(text);
            }
        }

        public void focusLost(FocusEvent e) {
            this.update((Text)e.widget);
        }

        private void update(Text text) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            String newText = text.getText();
            SgfId sgfType = (SgfId)text.getData();
            GameAnnotationPanel.this.updateProperty(newText, sgfType, GameAnnotationPanel.this.nodeView_);
            this.lastStringMap_.put(text, newText);
        }
    }

    private class SpinnerModifyListened
    implements ModifyListener {
        SpinnerModifyListened() {
        }

        public void modifyText(ModifyEvent e) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            RealEditor realEditor = (RealEditor)e.data;
            String newValue = realEditor.getDatum();
            SgfId sgfType = realEditor.getSgfId();
            GameAnnotationPanel.this.updateProperty(newValue, sgfType, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class ResultModifyListened
    implements ModifyListener {
        ResultModifyListened() {
        }

        public void modifyText(ModifyEvent e) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            ResultEditor editor = (ResultEditor)GameAnnotationPanel.this.widgetMap_.get(SgfId.RESULT);
            String newDatum = editor.getDatum();
            GameAnnotationPanel.this.updateProperty(newDatum, SgfId.RESULT, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor,
    ControllerStatusMonitor {
        private boolean panelIsShown_ = true;

        Adapter() {
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.panelIsShown_ = gameMediator.getGameType().equals(GameAnnotationPanel.this.gameType_);
            if (!this.panelIsShown_) {
                return;
            }
            NodeView currentNodeView = gameMediator.getCurrentNodeView();
            if (GameAnnotationPanel.this.nodeView_ == null) {
                GameAnnotationPanel.this.nodeView_ = currentNodeView;
            }
            this.updateImpl(currentNodeView);
        }

        public void currentChanged(NodeView nodeView) {
            if (!this.panelIsShown_) {
                return;
            }
            GameAnnotationPanel.this.nodeView_ = nodeView;
            this.updateImpl(GameAnnotationPanel.this.nodeView_);
        }

        private void updateImpl(NodeView nodeView) {
            GameAnnotationPanel.this.setModelUpdateMode(true);
            this.updateText(nodeView);
            this.updateSimpleTexts(nodeView);
            this.updateSpinner(nodeView);
            this.updateResult(nodeView);
            GameAnnotationPanel.this.setModelUpdateMode(false);
        }

        private void updateText(NodeView nodeView) {
            SgfId[] texts = new SgfId[]{SgfId.GAME_COMMENT};
            int i = 0;
            while (i < texts.length) {
                Text text = (Text)GameAnnotationPanel.this.widgetMap_.get(texts[i]);
                if (text != null) {
                    Property property = nodeView.findProperty(texts[i]);
                    String simpleText = "";
                    if (property != null) {
                        simpleText = property.value().getString();
                    }
                    if (!simpleText.equals(text.getText())) {
                        text.setText(simpleText);
                    }
                }
                ++i;
            }
        }

        private void updateSimpleTexts(NodeView nodeView) {
            int i = 0;
            while (i < TYPE_SIMPLE_TEXT.length) {
                Text text = (Text)GameAnnotationPanel.this.widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
                if (text != null) {
                    Property property = nodeView.findProperty(TYPE_SIMPLE_TEXT[i]);
                    String simpleText = "";
                    if (property != null) {
                        simpleText = Sgfs.unescapeSimpleTextForRead(property.value().getString());
                    }
                    if (!simpleText.equals(text.getText())) {
                        text.setText(simpleText);
                    }
                }
                ++i;
            }
        }

        private void updateSpinner(NodeView nodeView) {
            SgfId[] sgfIdArray = TYPE_SPINNER;
            int n = 0;
            int n2 = sgfIdArray.length;
            while (n < n2) {
                Property property;
                SgfId sgfId = sgfIdArray[n];
                RealEditor realEditor = (RealEditor)GameAnnotationPanel.this.widgetMap_.get(sgfId);
                if (realEditor != null && (property = nodeView.findProperty(sgfId)) != null) {
                    realEditor.setProperty(property);
                }
                ++n;
            }
        }

        private void updateResult(NodeView nodeView) {
            ResultEditor resultEditor = (ResultEditor)GameAnnotationPanel.this.widgetMap_.get(SgfId.RESULT);
            if (resultEditor != null) {
                resultEditor.setProperty(nodeView.findProperty(SgfId.RESULT));
            }
        }

        public void setEditMode(boolean isEditMode) {
            GameAnnotationPanel.this.isEditMode_ = isEditMode;
            int i = 0;
            while (i < TYPE_SIMPLE_TEXT.length) {
                Text text = (Text)GameAnnotationPanel.this.widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
                if (text != null) {
                    text.setEditable(GameAnnotationPanel.this.isEditMode_);
                }
                ++i;
            }
            SgfId[] sgfIdArray = TYPE_SPINNER;
            int text = 0;
            int n = sgfIdArray.length;
            while (text < n) {
                SgfId sgfId = sgfIdArray[text];
                RealEditor realEditor = (RealEditor)GameAnnotationPanel.this.widgetMap_.get(sgfId);
                if (realEditor != null) {
                    realEditor.setEditable(GameAnnotationPanel.this.isEditMode_);
                }
                ++text;
            }
            ResultEditor resultEditor = (ResultEditor)GameAnnotationPanel.this.widgetMap_.get(SgfId.RESULT);
            if (resultEditor != null) {
                resultEditor.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
            if ((text = (Text)GameAnnotationPanel.this.widgetMap_.get(SgfId.GAME_COMMENT)) != null) {
                text.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
        }

        public void changeHandlerPhase(HandlerPhase status) {
        }
    }
}

