/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.UndoComamnd;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(UndoAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(UndoAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;
    static /* synthetic */ Class class$0;

    public UndoAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String undoName) {
        this.setText(CLB_NAME.get((Object)undoName));
    }

    public UndoAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = controller;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        GameFrameController gfc = this.controller_.getActive();
        UndoComamnd comamnd = new UndoComamnd();
        gfc.getEventBroker().executeCommand(comamnd);
        CommandDriver.Status status = gfc.getCollectionEditor().getActiveGame().getCommandDriverStatus();
        if (status.getExecutedCommand() instanceof Command4NodeList) {
            gfc.updateByRedoUndo(((Command4NodeList)status.getExecutedCommand()).getInfluence());
        }
    }

    private class Adapter
    implements CommandDriverMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        Adapter() {
        }

        public void commandExecuted(CommandDriver.Status status) {
            ArgumentChecker.throwIfNull((Object)status);
            GameFrameController gfc = this.refGfc_.get();
            if (gfc != null) {
                UndoAction.this.setEnabled(gfc.isEditMode() && status.isUndoable());
                UndoAction.this.setCommandName(status.getUndoName());
            }
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(UndoAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            if (now == null) {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
                return;
            }
            now.getEventBroker().addView(UndoAction.this);
            CommandDriver.Status status = now.getCollectionEditor().getActiveGame().getCommandDriverStatus();
            UndoAction.this.setEnabled(now.isEditMode() && status.isUndoable());
            UndoAction.this.setCommandName(status.getUndoName());
        }

        public void setEditMode(boolean isEditMode) {
            GameFrameController now = this.refGfc_.get();
            if (now == null) {
                log_s_.warn("Lost GameFraemController (BUG)");
                return;
            }
            if (isEditMode) {
                CommandDriver.Status status = now.getCollectionEditor().getActiveGame().getCommandDriverStatus();
                UndoAction.this.setEnabled(status.isUndoable());
                UndoAction.this.setCommandName(status.getRedoName());
            } else {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
            }
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

