/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetMoveValueAction
extends AbstractAction
implements Adaptable {
    private static final Set<Property> exclusives_s_;
    private static final MessageResource LB_ADD;
    private static final MessageResource LB_REMOVE;
    private static final MessageResource CLB_NO_VALUE;
    private final Adapter adapter_ = new Adapter();
    private final Property property_;
    private PropertyLabelProvider provider_;
    private final Property[] exclusives_;
    private GameType gameType_;
    private boolean isAddMode_;
    static /* synthetic */ Class class$0;

    static {
        ArrayList<Property> list = new ArrayList<Property>(8);
        list.add(SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.TESUJI.makeProperty(SgfDouble.NORMAL));
        list.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED));
        list.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL));
        list.add(SgfId.INTERESTING.makeProperty(None.INSTANCE));
        list.add(SgfId.DOUBTFUL.makeProperty(None.INSTANCE));
        exclusives_s_ = Collections.unmodifiableSet(new HashSet(list));
        LB_ADD = new MessageResource(SetMoveValueAction.class, "lbAdd");
        LB_REMOVE = new MessageResource(SetMoveValueAction.class, "lbRemove");
        CLB_NO_VALUE = new MessageResource(SetMoveValueAction.class, "clbNoValue");
    }

    public SetMoveValueAction(WindowController controller, Property property) {
        super(controller);
        this.property_ = property == null ? null : new Property(property);
        this.provider_ = new BasicPropertyLabelProvider();
        this.gameType_ = GameType.GAME;
        HashSet<Property> set = new HashSet<Property>(exclusives_s_);
        if (this.property_ == null) {
            this.isAddMode_ = false;
        } else {
            this.isAddMode_ = true;
            if (!set.remove(this.property_)) {
                set.clear();
            } else if (this.property_.sgfId().valueType().equals((Object)ValueType.DOUBLE)) {
                set.remove(this.property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
                set.remove(this.property_.sgfId().makeProperty(SgfDouble.NORMAL));
            }
        }
        this.exclusives_ = set.toArray(new Property[set.size()]);
        this.updateText();
        this.setEnabled(false);
        this.controller_.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        UpdateProperty command = this.isAddMode_ || this.property_ == null ? new UpdateProperty(this.exclusives_, this.property_, null) : new UpdateProperty(new Property[]{this.property_}, null, null);
        this.controller_.getActive().getEventBroker().executeCommand(command);
    }

    private void updateText() {
        if (this.property_ == null) {
            this.setText(CLB_NO_VALUE.get());
            return;
        }
        this.setText(this.isAddMode_ ? LB_ADD.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)) : LB_REMOVE.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)));
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);
        private boolean hasMove_ = false;

        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(SetMoveValueAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(now);
            if (now != null) {
                now.getEventBroker().addView(SetMoveValueAction.this);
                SetMoveValueAction.this.gameType_ = now.getCollectionEditor().getActiveGame().getGameType();
            }
            this.update();
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            SetMoveValueAction.this.gameType_ = gameMediator.getGameType();
            this.update();
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            this.hasMove_ = nodeView.containsPropertyType(PropertyType.MOVE);
            boolean enableClear = false;
            if (SetMoveValueAction.this.property_ == null) {
                SetMoveValueAction.this.isAddMode_ = false;
                Property[] propertyArray = SetMoveValueAction.this.exclusives_;
                int n = 0;
                int n2 = propertyArray.length;
                while (n < n2) {
                    Property property = propertyArray[n];
                    if (nodeView.getProperty(property.sgfId()) != null) {
                        enableClear = true;
                        break;
                    }
                    ++n;
                }
                SetMoveValueAction.this.setEnabled(this.hasMove_ && enableClear);
                return;
            }
            Property property = nodeView.getProperty(SetMoveValueAction.this.property_.sgfId());
            SetMoveValueAction.this.isAddMode_ = property == null || !property.value().getString().equals(SetMoveValueAction.this.property_.value().getString());
            this.update();
            if (!SetMoveValueAction.this.isEnabled()) {
                return;
            }
        }

        private void update() {
            EnumSet<GameType> gameTypes = SetMoveValueAction.this.property_ == null ? EnumSet.of(SetMoveValueAction.this.gameType_) : SetMoveValueAction.this.property_.sgfId().gameTypes();
            GameFrameController gfc = this.refGfc_.get();
            SetMoveValueAction.this.setEnabled(this.hasMove_ && gfc != null && gfc.isEditMode() && gameTypes.contains(SetMoveValueAction.this.gameType_));
            if (gameTypes.contains(SetMoveValueAction.this.gameType_)) {
                SetMoveValueAction.this.updateText();
            } else {
                SetMoveValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
            }
        }

        public void setEditMode(boolean isEditMode) {
            GameFrameController gfc = this.refGfc_.get();
            this.currentChanged(gfc.getCollectionEditor().getActiveGame().getNodeList().getCurrentNodeView());
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }
    }
}

