/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

public class NewGameFileAction
extends Action {
    private static final MessageResource NT_DLG_TITLE = new MessageResource(NewGameFileAction.class, "ntDlgTitle");
    private static final MessageResource MSG_INSTRACTION = new MessageResource(NewGameFileAction.class, "msgInstraction");
    private final SgfSize sgfSize_;
    private final Handicap handicap_;
    private WindowController controller_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewGameFileAction(SgfSize sgfSize, int handicap) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        ArgumentChecker.throwIfNegative(handicap);
        this.sgfSize_ = sgfSize;
        this.handicap_ = new Handicap(handicap);
        this.controller_ = null;
        this.setText(this.handicap_.displayName());
    }

    public NewGameFileAction setController(WindowController controller) {
        ArgumentChecker.throwIfNull((Object)controller);
        this.controller_ = controller;
        return this;
    }

    public void run() {
        RootGameTree newRgt = RootGameTreeFactory.createGame(this.sgfSize_, this.handicap_);
        newRgt.setApplication(Application.create(Yukinoshita.instance().getName(), Yukinoshita.instance().getVersion()));
        GameFrameController target = null;
        if (this.controller_.getGameFrameControllers().length != 0) {
            SelectTargetFileDialog dialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE, SelectTargetFileDialog.Type.PERMITS_GAME));
            dialog.setShellTitle(NT_DLG_TITLE.get());
            dialog.setTitle(MSG_INSTRACTION.get());
            int ret = dialog.open();
            if (ret == 1) {
                return;
            }
            target = dialog.getTarget();
        }
        if (target == null) {
            Collection collection = new Collection();
            collection.addLast(newRgt);
            this.controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), false);
            EventBroker broker = this.controller_.getActive().getEventBroker();
            broker.executeCommand(new ChangeEditModeCommand(true));
            broker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
            return;
        }
        CollectionEditor editor = target.getCollectionEditor();
        editor.createGame(newRgt);
        for (CollectionMonitor viewer : target.getEventBroker().getListeners(CollectionMonitor.class)) {
            viewer.update(editor);
        }
        EventBroker broker = target.getEventBroker();
        broker.executeCommand(new GameChangeCommand(editor.size() - 1));
        broker.executeCommand(new ChangeEditModeCommand(true));
        broker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
    }
}

