/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;

public class MoveRootGameTreeAction
extends AbstractRootGameTreeAction {
    private static final MessageResource NT_MOVE = new MessageResource(MoveRootGameTreeAction.class, "ntMove");
    private static final MessageResource MSG_INSTRACTION = new MessageResource(MoveRootGameTreeAction.class, "msgInstraction");
    static /* synthetic */ Class class$0;

    public MoveRootGameTreeAction(WindowController controller) {
        super(controller);
    }

    public void run() {
        EnumSet<SelectTargetFileDialog.Type> typeSet = this.getTypes();
        GameFrameController gfc = this.getGameFrameController();
        GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType();
        SelectTargetFileDialog dialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), typeSet);
        dialog.setShellTitle(NT_MOVE.get((Object)gameType.displayName()));
        dialog.setTitle(MSG_INSTRACTION.get((Object)gameType.displayName()));
        int ret = dialog.open();
        if (ret == 1) {
            return;
        }
        GameFrameController target = dialog.getTarget();
        int activeGameIndex = gfc.getCollectionEditor().getActiveGameIndex();
        RootGameTree newRgt = gfc.getCollection().get(activeGameIndex);
        boolean finishTransaction = false;
        try {
            if (target == null) {
                Collection collection = new Collection();
                collection.addLast(newRgt);
                this.controller_.register(collection, BasicMessages.LB_NEW_FILE.get(), true);
                this.controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
                finishTransaction = true;
                return;
            }
            CollectionEditor editor = target.getCollectionEditor();
            editor.createGame(newRgt);
            this.notifyCollectionViewer(target);
            this.changeForLastGame(target);
            finishTransaction = true;
        }
        finally {
            if (finishTransaction) {
                gfc.getCollectionEditor().remove(activeGameIndex);
                this.notifyCollectionViewer(gfc);
                this.changeForLastGame(gfc);
            }
        }
    }
}

