/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRootGameTreeAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(AbstractRootGameTreeAction.class);
    private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);
    private final Adapter adapter_ = new Adapter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AbstractRootGameTreeAction(WindowController controller) {
        super(controller);
        controller.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    protected final GameFrameController getGameFrameController() {
        return this.refGfc_.get();
    }

    protected EnumSet<SelectTargetFileDialog.Type> getTypes() {
        EnumSet<SelectTargetFileDialog.Type> typeSet = EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE);
        GameFrameController gfc = this.getGameFrameController();
        if (gfc == null) {
            return typeSet;
        }
        GameType gameType = gfc.getCollectionEditor().getActiveGame().getGameType();
        switch (gameType) {
            case GAME: {
                typeSet.add(SelectTargetFileDialog.Type.PERMITS_GAME);
                return typeSet;
            }
            case PROBLEM: {
                typeSet.add(SelectTargetFileDialog.Type.PERMITS_PROBLEM);
                return typeSet;
            }
        }
        log_s_.warn("Unsupported game type (Maybe BUG). TYPE:" + gameType.name());
        return EnumSet.noneOf(SelectTargetFileDialog.Type.class);
    }

    protected boolean isRunnable(GameFrameController now) {
        if (now == null || !now.isEditMode()) {
            return false;
        }
        Collection collection = now.getCollection();
        if (collection.size() < 2) {
            return false;
        }
        return !GameType.DRILL.equals(collection.get(0).getGameType());
    }

    protected void notifyCollectionViewer(GameFrameController gfc) {
        CollectionEditor editor = gfc.getCollectionEditor();
        for (CollectionMonitor viewer : gfc.getEventBroker().getListeners(CollectionMonitor.class)) {
            viewer.update(editor);
        }
    }

    protected void changeForLastGame(GameFrameController gfc) {
        GameChangeCommand command = new GameChangeCommand(gfc.getCollectionEditor().size() - 1);
        gfc.getEventBroker().executeCommand(command);
    }

    private class Adapter
    implements WindowControllerListener,
    ControllerStatusMonitor,
    CollectionMonitor {
        Adapter() {
        }

        public void changeActive(GameFrameController now) {
            GameFrameController last = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            if (last != null) {
                last.getEventBroker().removeView(AbstractRootGameTreeAction.this);
            }
            if (now != null) {
                now.getEventBroker().addView(AbstractRootGameTreeAction.this);
            }
            AbstractRootGameTreeAction.this.refGfc_ = new WeakReference<GameFrameController>(now);
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(now));
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }

        public void setEditMode(boolean isEditMode) {
            GameFrameController gfc = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gfc));
        }

        public void update(CollectionEditor collectionEditor) {
            GameFrameController gfc = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gfc));
        }
    }
}

