/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.JFaceMenuManager;
import org.unitarou.yukinoshita.view.jface.dlg.AskSaveDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.gm.GameSingleFrame;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceWindow
extends ApplicationWindow
implements Adaptable,
WindowController {
    private static final Log log_s_ = LogFactory.getLog(JFaceWindow.class);
    private static final String MARK_EDITED = "*";
    private static ImageResource[] IMG_APPS = null;
    private static final MessageResource NT_FILE_SAVE_FAILURE = new MessageResource(JFaceWindow.class, "ntFileSaveFailure");
    public static final MessageResource NT_YUKINOSHITS = new MessageResource(JFaceWindow.class, "ntYukinoshita");
    private static final IntArrayContextValue SIZE = new IntArrayContextValue(JFaceWindow.class, "size", 800, 640);
    private final JFaceMenuManager menuManager_;
    private CTabFolder tabFolder_ = null;
    private final Adapter adapter_;
    private final ShellAdapter shellAdapter_;
    private final Notifier notifier_;
    private final List<WindowControllerListener> listeners_ = new ArrayList<WindowControllerListener>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static Image[] getAppIcons() {
        if (IMG_APPS == null) {
            IMG_APPS = new ImageResource[2];
            JFaceWindow.IMG_APPS[0] = new ImageResource(JFaceWindow.class, "iconApp16.png");
            JFaceWindow.IMG_APPS[1] = new ImageResource(JFaceWindow.class, "iconApp32.png");
        }
        return new Image[]{IMG_APPS[0].get(), IMG_APPS[1].get()};
    }

    public JFaceWindow(Shell parentShell) {
        super(parentShell);
        this.menuManager_ = new JFaceMenuManager(this);
        super.addMenuBar();
        this.adapter_ = new Adapter();
        this.shellAdapter_ = new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                JFaceWindow.this.closeThis(event);
            }
        };
        this.notifier_ = new Notifier();
    }

    private void closeThis(ShellEvent event) {
        event.doit = this.closeAllTabs();
        if (event.doit) {
            super.close();
        }
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void create() {
        super.create();
        this.menuManager_.initialize();
    }

    @Override
    protected Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        this.getShell().setImages(JFaceWindow.getAppIcons());
        this.getShell().setText(NT_YUKINOSHITS.get((Object)Yukinoshita.instance().getVersion()));
        this.tabFolder_ = new CTabFolder(parent, 2240);
        this.tabFolder_.setSimple(false);
        this.tabFolder_.addCTabFolder2Listener(new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                GameFrameController gfc = (GameFrameController)event.item.getData();
                event.doit = JFaceWindow.this.closeTab(gfc);
                if (event.doit) {
                    event.item.setData(null);
                    event.item.dispose();
                    JFaceWindow.this.changeCurrentTabItem();
                }
            }
        });
        this.tabFolder_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFaceWindow.this.changeCurrentTabItem();
            }
        });
        Display display = this.tabFolder_.getDisplay();
        this.tabFolder_.setSelectionBackground(new Color[]{display.getSystemColor(20), display.getSystemColor(22)}, new int[]{100}, true);
        CurrentContext context = Yukinoshita.context().getCurrent(null);
        int[] size = context.getIntArray(SIZE);
        this.getShell().setSize(size[0], size[1]);
        return this.tabFolder_;
    }

    private void changeCurrentTabItem() {
        GameFrameController gfc = this.getActive();
        for (WindowControllerListener listener : this.listeners_) {
            listener.changeActive(gfc);
        }
        if (gfc != null) {
            NodeView nodeView = gfc.getCollectionEditor().getActiveGame().getCurrentNodeView();
            for (NodeMonitor nodeMonitor : gfc.getEventBroker().getListeners(NodeMonitor.class)) {
                nodeMonitor.currentChanged(nodeView);
            }
        }
        this.updateFileModifyMark();
    }

    private void updateFileModifyMark() {
        String name;
        CTabItem item = this.tabFolder_.getSelection();
        if (item == null) {
            log_s_.warn("Selected tabitem is not found.");
            return;
        }
        GameFrameController gfc = this.getActive();
        File file = gfc.getCollection().getFile();
        String string = name = file != null ? file.getName() : item.getText();
        if (name.startsWith(MARK_EDITED)) {
            name = name.substring(MARK_EDITED.length());
        }
        item.setText(gfc.isChanged() ? MARK_EDITED + name : name);
    }

    @Override
    protected ShellListener getShellListener() {
        return this.shellAdapter_;
    }

    private ModelFrame createGameFrame(String tabName) {
        GameSingleFrame modelFrame = new GameSingleFrame();
        Control control = modelFrame.createContents(this.tabFolder_);
        CTabItem item = new CTabItem(this.tabFolder_, 0);
        item.setText(tabName);
        item.setControl(control);
        this.tabFolder_.setSelection(item);
        return modelFrame;
    }

    @Override
    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        this.menuManager_.createMenu(menuManager);
        return menuManager;
    }

    @Override
    public boolean close() {
        if (this.closeAllTabs()) {
            return super.close();
        }
        return false;
    }

    private boolean closeAllTabs() {
        CTabItem[] items = this.tabFolder_.getItems();
        int i = 0;
        while (i < items.length) {
            GameFrameController gfc = (GameFrameController)items[i].getData();
            boolean doit = this.closeTab(gfc);
            if (!doit) {
                return false;
            }
            items[i].setData(null);
            items[i].dispose();
            ++i;
        }
        return true;
    }

    private boolean closeTab(GameFrameController gfc) {
        if (gfc == null) {
            return true;
        }
        if (!gfc.isChanged()) {
            FileManager.instance().close(gfc.getCollection());
            gfc.getEventBroker().removeView(this);
            gfc.dispose();
            return true;
        }
        AskSaveDialog dialog = new AskSaveDialog(this.getShell(), gfc);
        int id = dialog.open();
        switch (id) {
            case 1025: {
                File file = IgoFileDialog.askSaveFile(gfc.getCollection());
                if (file == null) {
                    return false;
                }
                FileManager.instance().close(gfc.getCollection());
                gfc.getCollection().setFile(file);
            }
            case 1024: {
                try {
                    FileManager.instance().save(gfc.getCollection());
                }
                catch (YukinoshitaException e) {
                    log_s_.error(NT_FILE_SAVE_FAILURE.get(), e);
                    MessageDialog.openError(this.getShell(), NT_FILE_SAVE_FAILURE.get(), e.getLocalizedMessage());
                    return false;
                }
            }
            case 1026: {
                FileManager.instance().close(gfc.getCollection());
                gfc.getEventBroker().removeView(this);
                gfc.dispose();
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void register(Collection collection, String tabName, boolean setChangedFlag) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() == null && tabName == null) {
            throw new IllegalArgumentException("No tabName");
        }
        if (collection.getFile() != null) {
            tabName = collection.getFile().getName();
        }
        ModelFrame mf = this.createGameFrame(tabName);
        GameFrameController gfc = new GameFrameController(collection, mf, setChangedFlag);
        gfc.getEventBroker().addView(this);
        this.notifier_.setEventBroker(gfc.getEventBroker());
        this.tabFolder_.getSelection().setData(gfc);
        this.changeCurrentTabItem();
    }

    @Override
    public GameFrameController getActive() {
        CTabItem tabItem = this.tabFolder_.getSelection();
        return tabItem != null ? (GameFrameController)tabItem.getData() : null;
    }

    @Override
    public GameFrameController[] getGameFrameControllers() {
        CTabItem[] items = this.tabFolder_.getItems();
        GameFrameController[] ret = new GameFrameController[items.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (GameFrameController)items[i].getData();
            ++i;
        }
        return ret;
    }

    @Override
    public boolean closeActive() {
        CTabItem tabItem = this.tabFolder_.getSelection();
        if (tabItem == null) {
            return false;
        }
        GameFrameController gfc = (GameFrameController)tabItem.getData();
        if (this.closeTab(gfc)) {
            tabItem.setData(null);
            tabItem.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void addListener(WindowControllerListener listener) {
        if (listener != null) {
            this.listeners_.add(listener);
        }
    }

    @Override
    public void removListener(WindowControllerListener listener) {
        this.listeners_.remove(listener);
    }

    @Override
    public void defaultLayout() {
        int[] size = SIZE.defaultIntArray();
        this.getShell().setSize(size[0], size[1]);
        GameFrameController gfc = this.getActive();
        if (gfc == null) {
            return;
        }
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
            viewer.defaultLayout();
        }
    }

    @Override
    public void loadLayout() {
        CurrentContext context = Yukinoshita.context().getCurrent(null);
        int[] size = context.getIntArray(SIZE);
        this.getShell().setSize(size[0], size[1]);
        GameFrameController gfc = this.getActive();
        if (gfc == null) {
            return;
        }
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
            viewer.loadLayout();
        }
    }

    @Override
    public void saveLayout() {
        CurrentContext context = Yukinoshita.context().getCurrent(null);
        Point point = this.getShell().getSize();
        context.setIntArray(SIZE.id(), new int[]{point.x, point.y});
        GameFrameController gfc = this.getActive();
        if (gfc == null) {
            Yukinoshita.context().saveContext();
            return;
        }
        for (LayoutMonitor viewer : gfc.getEventBroker().getListeners(LayoutMonitor.class)) {
            viewer.saveLayout();
        }
        Yukinoshita.context().saveContext();
    }

    private class Adapter
    implements NodeMonitor,
    GameInfoNodeMonitor {
        Adapter() {
        }

        public void currentChanged(NodeView nodeView) {
            JFaceWindow.this.updateFileModifyMark();
        }

        public void gameInfoUpdated(NodeView gameInfoNode) {
            JFaceWindow.this.updateFileModifyMark();
        }
    }

    private class Notifier
    extends TieredModelEventNotifier {
        Notifier() {
        }

        protected Adaptable[] getAdaptables() {
            return new Adaptable[]{JFaceWindow.this.menuManager_};
        }
    }
}

