/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.DefaultContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceContext
extends PreferenceStore
implements Context {
    private static String DELIMITER_ARRAY = ",";
    private static final Log log_s_ = LogFactory.getLog(JFaceContext.class);
    private static final MessageResource MSG_IO_ERROR_IN_RESTORE = new MessageResource(JFaceContext.class, "msgIoErrorInRestore");
    private static final MessageResource MSG_IO_ERROR_IN_SAVE = new MessageResource(JFaceContext.class, "msgIoErrorInSave");
    private final DefaultContext defaultContext_;
    private final WeakHashMap<Object, CurrentContext> contextMap_;
    private File file_;
    static /* synthetic */ Class class$0;

    public JFaceContext() {
        this.setFilename(String.valueOf(Yukinoshita.USER_NAME) + ".preference");
        this.defaultContext_ = new DefaultContext();
        this.contextMap_ = new WeakHashMap();
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JFaceContext.this.propertyChangeImpl(event.getProperty(), event.getNewValue());
            }
        });
    }

    private void propertyChangeImpl(String key, Object value) {
        if (value == null) {
            return;
        }
        Object lastVal = this.getAttribute(key, null);
        Object newVal = null;
        if (lastVal == null || lastVal.getClass().isAssignableFrom(value.getClass())) {
            newVal = value;
        } else if (lastVal instanceof Integer) {
            newVal = new Integer(value.toString());
        } else if (lastVal instanceof int[]) {
            newVal = this.parseIntArray(value);
        } else if (lastVal instanceof Boolean) {
            newVal = new Boolean(value.toString());
        } else if (lastVal instanceof Enum) {
            ?[] objArray = lastVal.getClass().getEnumConstants();
            int n = 0;
            int n2 = objArray.length;
            while (n < n2) {
                Object obj = objArray[n];
                if (((Enum)obj).name().equals(value.toString())) {
                    newVal = obj;
                }
                ++n;
            }
        } else if (lastVal instanceof Provider) {
            try {
                newVal = Class.forName(value.toString()).newInstance();
            }
            catch (Exception e) {
                log_s_.warn(String.valueOf(e.getMessage()) + " Bad class name: " + value);
            }
        } else if (lastVal instanceof File) {
            newVal = new File(lastVal.toString());
        } else {
            log_s_.warn(this.composeWarnMsgUnknownTypeValue(key, lastVal));
        }
        if (newVal == null) {
            return;
        }
        this.defaultContext_.setAttribute(key, newVal, null);
        this.defaultContext_.fireAttributeChanged(new String[]{key});
        if (log_s_.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Property changed. ");
            builder.append(key).append("=").append(value);
            log_s_.debug(builder.toString());
        }
    }

    private int[] parseIntArray(Object value) {
        if (value instanceof int[]) {
            int[] newArray = new int[((int[])value).length];
            System.arraycopy(value, 0, newArray, 0, newArray.length);
            return newArray;
        }
        if (!(value instanceof String)) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer((String)value, DELIMITER_ARRAY);
        while (tokenizer.hasMoreTokens()) {
            try {
                String token = tokenizer.nextToken();
                Integer integer = Integer.decode(token.trim());
                list.add(integer);
            }
            catch (NumberFormatException e) {
                log_s_.warn("Bad value.", e);
                return null;
            }
        }
        int[] ret = new int[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Integer)list.get(i);
            ++i;
        }
        return ret;
    }

    private String formatIntArray(int[] value) {
        if (value.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int[] nArray = value;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int element = nArray[n];
            builder.append(element).append(DELIMITER_ARRAY);
            ++n;
        }
        builder.delete(builder.length() - DELIMITER_ARRAY.length(), builder.length());
        return builder.toString();
    }

    private String composeWarnMsgUnknownTypeValue(String key, Object value) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unknown value type, ignore this attribute: (");
        builder.append(key).append("=").append(value);
        builder.append(") class=").append(value.getClass());
        return builder.toString();
    }

    private String composeMsgMismatchValueType(String key, Object value, Class clazz) {
        StringBuilder builder = new StringBuilder();
        builder.append("Bad value type, use default value. key='").append(key);
        builder.append("', value='").append(value);
        builder.append("', class=" + clazz);
        return builder.toString();
    }

    @Override
    public void loadContext() {
        this.file_ = new File(String.valueOf(Yukinoshita.USER_NAME) + ".preference").getAbsoluteFile();
        FileInputStream inputStream = null;
        try {
            try {
                FileUtils.touch(this.file_);
                inputStream = new FileInputStream(this.file_);
                this.load(inputStream);
                String[] stringArray = this.preferenceNames();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String key = stringArray[n];
                    this.propertyChangeImpl(key, this.getString(key));
                    ++n;
                }
            }
            catch (IOException e) {
                log_s_.warn(String.valueOf(e.getMessage()) + " File: " + this.file_.toString());
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_INPUT.get(), MSG_IO_ERROR_IN_RESTORE.get((Object)e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        this.setFilename(this.file_.getAbsolutePath());
    }

    @Override
    public void saveContext() {
        try {
            super.save();
        }
        catch (IOException e) {
            log_s_.warn("Cant save context. Reason: " + e.getMessage());
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_OUTPUT.get(), MSG_IO_ERROR_IN_SAVE.get((Object)e.getMessage()));
        }
    }

    @Override
    public void addListener(ContextListener listener) {
        this.defaultContext_.addListener(listener);
    }

    @Override
    public Object[] clearCurrent(Object scope) {
        this.contextMap_.remove(scope);
        return this.defaultContext_.clearCurrent(scope);
    }

    @Override
    public void fireAttributeChanged(String[] keys) {
        this.defaultContext_.fireAttributeChanged(keys);
    }

    @Override
    public Object getAttribute(String key, Object scope) {
        return this.defaultContext_.getAttribute(key, scope);
    }

    @Override
    public CurrentContext getCurrent(Object scope) {
        CurrentContext ret = this.contextMap_.get(scope);
        if (ret == null) {
            ret = new CurrentContextImpl(scope);
            this.contextMap_.put(scope, ret);
        }
        return ret;
    }

    @Override
    public <T extends Provider> T getProvider(Class<T> provider, Object scope) {
        return this.defaultContext_.getProvider(provider, scope);
    }

    @Override
    public <T extends Provider> T[] getProviders(Class<T> provider) {
        return this.defaultContext_.getProviders(provider);
    }

    @Override
    public boolean registerInterface(Class<?> provider) {
        return this.defaultContext_.registerInterface((Class)provider);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.defaultContext_.getInterfaces();
    }

    @Override
    public Class<?>[] registerProvider(Class<?> concreteProvider) {
        Class<?>[] classes;
        Class<?>[] classArray = classes = this.defaultContext_.registerProvider(concreteProvider);
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?> clazz = classArray[n];
            String key = clazz.getName();
            if (!this.contains(key)) {
                this.setDefault(key, concreteProvider.getName());
            }
            ++n;
        }
        return classes;
    }

    @Override
    public void removeListener(ContextListener listener) {
        this.defaultContext_.removeListener(listener);
    }

    @Override
    public void setAttribute(String key, Object value, Object scope) {
        this.defaultContext_.setAttribute(key, value, scope);
        if (scope != null) {
            return;
        }
        if (value instanceof Boolean) {
            this.setValue(key, (Boolean)value);
        } else if (value instanceof Double) {
            this.setValue(key, (Double)value);
        } else if (value instanceof Float) {
            this.setValue(key, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.setValue(key, (Long)value);
        } else if (value instanceof Integer) {
            this.setValue(key, (Integer)value);
        } else if (value instanceof int[]) {
            this.setValue(key, this.formatIntArray((int[])value));
        } else if (value instanceof Enum) {
            this.setValue(key, ((Enum)value).name());
        } else if (value instanceof String) {
            this.setValue(key, (String)value);
        } else if (value instanceof Provider) {
            this.setValue(key, value.getClass().getName());
        } else if (value instanceof File) {
            this.setValue(key, ((File)value).getAbsolutePath());
        } else {
            log_s_.warn(this.composeWarnMsgUnknownTypeValue(key, value));
            return;
        }
    }

    @Override
    public void setAttribute(ContextValue attribute, Object scope) {
        ArgumentChecker.throwIfNull((Object)attribute);
        String key = attribute.id();
        Object value = attribute.defaultValue();
        this.setAttribute(key, value, scope);
        this.setDefault(key, value);
    }

    private void setDefault(String key, Object value) {
        if (value instanceof Boolean) {
            this.setDefault(key, (Boolean)value);
        } else if (value instanceof Double) {
            this.setDefault(key, (Double)value);
        } else if (value instanceof Float) {
            this.setDefault(key, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.setDefault(key, (Long)value);
        } else if (value instanceof Integer) {
            this.setDefault(key, (Integer)value);
        } else if (value instanceof Enum) {
            this.setDefault(key, ((Enum)value).name());
        } else if (value instanceof String) {
            this.setDefault(key, (String)value);
        } else if (value instanceof Provider) {
            this.setDefault(key, value.getClass().getName());
        } else if (value instanceof File) {
            this.setDefault(key, ((File)value).getAbsolutePath());
        } else {
            log_s_.warn(this.composeWarnMsgUnknownTypeValue(key, value));
            return;
        }
    }

    @Override
    public String[] rootKeys() {
        return this.defaultContext_.rootKeys();
    }

    @Override
    public void setProvider(Class<?> providerInterface, Class<?> provider, Object scope) {
        this.defaultContext_.setProvider(providerInterface, provider, scope);
        String key = providerInterface.getName();
        if (scope != null || this.contains(key)) {
            return;
        }
        this.setValue(key, provider.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentContextImpl
    implements CurrentContext {
        private final WeakReference<Object> reference_;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        CurrentContextImpl(Object scope) {
            this.reference_ = new WeakReference<Object>(scope);
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> providerInterface) {
            return JFaceContext.this.getProvider(providerInterface, this.reference_.get());
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> providerInterface, Provider provider) {
            JFaceContext.this.setAttribute(providerInterface.getName(), provider, this.reference_.get());
        }

        @Override
        public boolean getBoolean(String key) {
            Object value = JFaceContext.this.getAttribute(key, this.reference_.get());
            if (value == null || !(value instanceof Boolean)) {
                this.throwIllegalStateException(key, value);
            }
            return (Boolean)value;
        }

        @Override
        public boolean getBoolean(BooleanContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            Object attr = JFaceContext.this.getAttribute(value.id(), this.reference_.get());
            if (attr == null || !(attr instanceof Boolean)) {
                return value.defaultBoolean();
            }
            return (Boolean)attr;
        }

        @Override
        public int getInteger(IntContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            return this.getInteger(value.id(), value.defaultInt());
        }

        @Override
        public int getInteger(String key, int defaultValue) {
            Object value = JFaceContext.this.getAttribute(key, this.reference_.get());
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    log_s_.warn("Cant parse value: " + value);
                }
            }
            log_s_.warn(JFaceContext.this.composeMsgMismatchValueType(key, value, int[].class));
            return defaultValue;
        }

        @Override
        public void setInteger(String key, int value) {
            JFaceContext.this.setAttribute(key, new Integer(value), this.reference_.get());
        }

        @Override
        public int[] getIntArray(String key, int[] defaultValue) {
            Object value = JFaceContext.this.getAttribute(key, this.reference_.get());
            if (value == null) {
                return defaultValue;
            }
            int[] ret = JFaceContext.this.parseIntArray(value);
            if (ret != null) {
                return ret;
            }
            log_s_.warn(JFaceContext.this.composeMsgMismatchValueType(key, value, int[].class));
            return defaultValue;
        }

        @Override
        public int[] getIntArray(IntArrayContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            return this.getIntArray(value.id(), value.defaultIntArray());
        }

        @Override
        public void setIntArray(String key, int[] value) {
            ArgumentChecker.throwIfNull((Object)value);
            JFaceContext.this.setAttribute(key, value, this.reference_.get());
        }

        @Override
        public File getFile(FileContextValue value) {
            ArgumentChecker.throwIfNull((Object)value);
            Object obj = JFaceContext.this.getAttribute(value.id(), this.reference_.get());
            if (obj == null) {
                return value.defaultFile();
            }
            if (obj instanceof String) {
                obj = new File((String)obj);
            }
            if (!(obj instanceof File)) {
                log_s_.warn(JFaceContext.this.composeMsgMismatchValueType(value.id(), obj, File.class));
                return value.defaultFile();
            }
            return (File)obj;
        }

        @Override
        public void setFile(String key, File file) {
            ArgumentChecker.throwIfNull((Object)file);
            JFaceContext.this.setAttribute(key, file, this.reference_.get());
        }

        private void throwIllegalStateException(String key, Object value) {
            throw new IllegalStateException("Bad value. key='" + key + "', value='" + value + "' " + "class=" + (value == null ? "null" : value.getClass().getName()));
        }
    }
}

