/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

public abstract class AbstractCommand4View
implements Command4View {
    private static final Log log_s_ = LogFactory.getLog(AbstractCommand4View.class);
    private final ParameterImpl parameter_ = new ParameterImpl();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public final Command4View.Parameter getParameter() {
        return this.parameter_;
    }

    protected final CollectionEditor getCollectionEditor() {
        return this.parameter_.collectionEditor_;
    }

    protected final EventBroker getEventBroker() {
        return this.parameter_.eventBroker_;
    }

    protected final Boolean isEditMode() {
        return this.parameter_.isEditMode_;
    }

    protected final void fireCollectionViewerUpdate() {
        this.throwIfNotSetup();
        GameType gameType = this.parameter_.collectionEditor_.getActiveGame().getGameType();
        this.parameter_.eventBroker_.connect(gameType, this.parameter_.isEditMode_);
        for (CollectionMonitor viewer : this.parameter_.eventBroker_.getListeners(CollectionMonitor.class)) {
            viewer.update(this.parameter_.collectionEditor_);
        }
    }

    protected final void fireGameViewerUpdate() {
        this.throwIfNotSetup();
        ViewerUtils.setupDriiRootDirectory(this.parameter_.collectionEditor_.getCollection());
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        for (GameMonitor gameViewer : this.parameter_.eventBroker_.getListeners(GameMonitor.class)) {
            gameViewer.update(gameMediator);
        }
    }

    protected final void fireGameInfoNodeUpdate() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        int index = gameMediator.findNodeView(PropertyType.GAME_INFO);
        if (index < 0) {
            index = 0;
        }
        NodeView target = gameMediator.getNodeList().getNodeView(index);
        this.fireGameInfoNodeUpdate(target);
    }

    protected final void fireGameInfoNodeUpdate(NodeView target) {
        this.throwIfNotSetup();
        for (GameInfoNodeMonitor monitor : this.parameter_.eventBroker_.getListeners(GameInfoNodeMonitor.class)) {
            monitor.currentChanged(target);
        }
    }

    protected final void fireNodeListUpdate() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        NodeList nodeList = gameMediator.getNodeList();
        int start = gameMediator.getCurrentNodeIndex();
        int end = nodeList.size();
        int index = 0;
        NodeView[] nodeViews = new NodeView[end - start];
        int i = start;
        while (i < end) {
            nodeViews[index] = nodeList.getNodeView(i);
            ++index;
            ++i;
        }
        for (NodeListMonitor nodeListViewer : this.parameter_.eventBroker_.getListeners(NodeListMonitor.class)) {
            nodeListViewer.update(nodeViews);
        }
    }

    protected final void fireNodeViewerUpdate() {
        this.fireNodeViewerUpdate(0);
    }

    protected final void fireNodeViewerUpdate(int delta) {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        int index = gameMediator.getCurrentNodeIndex() + delta;
        if (index < 0 || gameMediator.getNodeList().size() <= index) {
            index = gameMediator.getCurrentNodeIndex();
            log_s_.warn("Bad index, index=" + index + ", delta=" + delta);
        }
        NodeView nodeView = gameMediator.getNodeList().getNodeView(index);
        for (NodeMonitor nodeViewer : this.parameter_.eventBroker_.getListeners(NodeMonitor.class)) {
            nodeViewer.currentChanged(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(String.valueOf(stopWatch.lapSecond()) + " secs for " + nodeViewer);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for fireNodeViewerUpdate");
        }
    }

    protected final void fireHandlerPhaseChange(HandlerPhase phase) {
        ArgumentChecker.throwIfNull((Object)phase);
        if (phase.equals(HandlerPhase.SOLVE)) {
            this.parameter_.collectionEditor_.getActiveGame().startSolvingProblem();
            this.fireNodeViewerUpdate();
        }
        for (ControllerStatusMonitor viewer : this.parameter_.eventBroker_.getListeners(ControllerStatusMonitor.class)) {
            viewer.changeHandlerPhase(phase);
        }
    }

    protected final void fireProblemStatusUpdate(ProblemStatus problemStatus) {
        ArgumentChecker.throwIfNull((Object)problemStatus);
        for (ProblemStatusMonitor viewer : this.parameter_.eventBroker_.getListeners(ProblemStatusMonitor.class)) {
            viewer.update(problemStatus);
        }
    }

    protected void fireCommandDriverExecuted(CommandDriver.Status status) {
        ArgumentChecker.throwIfNull((Object)status);
        for (CommandDriverMonitor listener : this.parameter_.eventBroker_.getListeners(CommandDriverMonitor.class)) {
            listener.commandExecuted(status);
        }
    }

    protected final void throwIfNotSetup() {
        if (this.parameter_.collectionEditor_ == null || this.parameter_.eventBroker_ == null || this.parameter_.isEditMode_ == null) {
            throw new IllegalStateException("Bad state, CollectionEditor and EventBroker must be set before method invocationcollectionEditor_=" + this.parameter_.collectionEditor_ + ", eventBroker_=" + this.parameter_.eventBroker_ + ", isEditMode_=" + this.parameter_.isEditMode_);
        }
    }

    private class ParameterImpl
    implements Command4View.Parameter {
        private CollectionEditor collectionEditor_;
        private EventBroker eventBroker_;
        private Boolean isEditMode_;
        private HandlerPhase currentStatus_;

        ParameterImpl() {
        }

        public CollectionEditor getCollectionEditor() {
            return this.collectionEditor_;
        }

        public EventBroker getEventBroker() {
            return this.eventBroker_;
        }

        public Boolean isEditMode() {
            return this.isEditMode_;
        }

        public HandlerPhase getCurrentStatus() {
            return this.currentStatus_;
        }

        public void set(CollectionEditor collectionEditor, EventBroker eventBroker, boolean isEditMode) {
            ArgumentChecker.throwIfNull((Object)collectionEditor, (Object)eventBroker);
            this.collectionEditor_ = collectionEditor;
            this.eventBroker_ = eventBroker;
            this.isEditMode_ = new Boolean(isEditMode);
        }

        public void setCollectionEditor(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            this.collectionEditor_ = collectionEditor;
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_ = eventBroker;
        }

        public void setEditMode(boolean isEditMode) {
            this.isEditMode_ = new Boolean(isEditMode);
        }

        public void setCurrentStatus(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            this.currentStatus_ = handlerPhase;
        }
    }
}

