/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.cmd.EditProperty;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.AddNode;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateProperty
extends Command4NodeList {
    private static final Log log_s_ = LogFactory.getLog(UpdateProperty.class);
    private static final MessageResource LB_ADD_NAME = new MessageResource(UpdateProperty.class, "lbAddName");
    private static final MessageResource LB_EDIT_NAME = new MessageResource(UpdateProperty.class, "lbEditName");
    private static final MessageResource LB_DELETE_NAME = new MessageResource(UpdateProperty.class, "lbDeleteName");
    private final Property[] excluded_;
    private final Property include_;
    private final PropertyType propertyType_;
    private NodeEntity target_;
    private EditProperty[] editProperties_;
    private boolean hasRgtInfluence_;
    private EnumSet<ModelInfluence> influences_;
    private Command addNode_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public UpdateProperty(Property[] excluded, Property include, PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)excluded);
        this.editProperties_ = null;
        this.hasRgtInfluence_ = false;
        this.addNode_ = NullCommand.INSTANCE;
        this.excluded_ = new Property[excluded.length];
        System.arraycopy(excluded, 0, this.excluded_, 0, this.excluded_.length);
        this.include_ = include;
        this.propertyType_ = propertyType;
        this.influences_ = EnumSet.noneOf(ModelInfluence.class);
    }

    @Override
    protected boolean setup() {
        if (this.editProperties_ != null) {
            return true;
        }
        EditableNodeList nodeList_ = this.getEditableNodeList();
        if (nodeList_ == null) {
            return false;
        }
        this.target_ = nodeList_.getPosition();
        if (this.propertyType_ == null) {
            this.influences_.add(ModelInfluence.NODE_CURRENT);
        } else {
            int index = nodeList_.getPositionIndex();
            while (index >= 0) {
                NodeEntity entity = nodeList_.get(index);
                if (entity.getNode().contains(this.propertyType_)) {
                    this.target_ = nodeList_.get(index);
                    break;
                }
                --index;
            }
            if (this.propertyType_.equals(PropertyType.ROOT) && index != 0) assert (false) : "Bad strucuture.";
            switch (this.propertyType_) {
                case GAME_INFO: {
                    this.influences_.add(ModelInfluence.NODE_GAMEINFO);
                    break;
                }
                case ROOT: {
                    this.influences_.add(ModelInfluence.ROOT_GAME_TREE);
                    break;
                }
                default: {
                    int delta = index - nodeList_.getPositionIndex();
                    if (delta == 0) {
                        this.influences_.add(ModelInfluence.NODE_CURRENT);
                        break;
                    }
                    log_s_.warn("Unsupported update type: index - curIndex:" + delta);
                }
            }
        }
        ArrayList<EditProperty> commands = new ArrayList<EditProperty>(this.excluded_.length + 1);
        if (this.include_ == null) {
            String deleteTypeName = this.composeDeleteCommandName(this.target_, this.excluded_);
            if (!deleteTypeName.equals("")) {
                this.setDisplayName(LB_DELETE_NAME.get((Object)deleteTypeName));
            }
        } else {
            if (this.target_.getNode().contains(this.include_.sgfId())) {
                this.setDisplayName(LB_EDIT_NAME.get((Object)this.include_.sgfId().displayName()));
            } else {
                this.setDisplayName(LB_ADD_NAME.get((Object)this.include_.sgfId().displayName()));
            }
            commands.add(new EditProperty(this.target_.getNode(), this.include_, EditProperty.ADD_OR_REPLACE));
            if (nodeList_.size() == 1 && this.include_.sgfId().equals(SgfId.GAME_TYPE) && this.include_.value().getStrings()[0].equals(GameType.DRILL.getString())) {
                Node node = new Node(SgfId.PROBLEM_PROPERTIES.makeProperty(new ProblemProperties(0)));
                AddNode addNode = new AddNode(node);
                addNode.setEditableNodeList(nodeList_);
                this.addNode_ = addNode;
            }
        }
        int i = 0;
        while (i < this.excluded_.length) {
            commands.add(new EditProperty(this.target_.getNode(), this.excluded_[i], EditProperty.DELETE));
            ++i;
        }
        this.editProperties_ = commands.toArray(new EditProperty[commands.size()]);
        this.setExecutedNodeIndex(nodeList_.getPositionIndex());
        this.setUndoneNodeIndex(nodeList_.getPositionIndex());
        return true;
    }

    private String composeDeleteCommandName(NodeEntity target, Property[] excluded) {
        int i = 0;
        while (i < excluded.length) {
            Property p = target.getNode().getProperty(excluded[i].sgfId());
            if (p != null && p.sgfId().equals(excluded[i].sgfId())) {
                return excluded[i].sgfId().displayName();
            }
            ++i;
        }
        return "";
    }

    @Override
    public void execute() {
        super.execute();
        HashSet<SgfId> updateIds = new HashSet<SgfId>(this.editProperties_.length);
        EditProperty[] editPropertyArray = this.editProperties_;
        int n = 0;
        int n2 = editPropertyArray.length;
        while (n < n2) {
            EditProperty editProperty = editPropertyArray[n];
            editProperty.execute();
            updateIds.add(editProperty.getSgfId());
            ++n;
        }
        this.addNode_.execute();
        this.hasRgtInfluence_ = this.getEditableNodeList().refresh(updateIds);
        if (!this.hasRgtInfluence_) {
            this.target_.update();
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.addNode_.undo();
        HashSet<SgfId> updateIds = new HashSet<SgfId>(this.editProperties_.length);
        EditProperty[] editPropertyArray = this.editProperties_;
        int n = 0;
        int n2 = editPropertyArray.length;
        while (n < n2) {
            EditProperty editProperty = editPropertyArray[n];
            editProperty.undo();
            updateIds.add(editProperty.getSgfId());
            ++n;
        }
        this.hasRgtInfluence_ = this.getEditableNodeList().refresh(updateIds);
        if (!this.hasRgtInfluence_) {
            this.target_.update();
        }
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return this.influences_;
    }
}

